//=============================================================================
// Tank.
//=============================================================================
class Tank expands Drivable;

// Tank uses forward/backward and strafe controls for control of the vehicle.
// Lookup and turn can be used for other drivables, or for looking around.

simulated function InterpretControls(bool bJustFired,bool bFire,bool bJustAltFired,bool bAltFire,
                           float aVehicleSpeedControl,float aTurretTurn,float aVehicleTurn,
                           float aVehicleUp,float aTurretUp,bool bJustJumped,bool bJustDucked)
{
 local float NewDesiredSpeed;

 if(aVehicleTurn<0)
  controlinputYaw = (aVehicleTurn/16384.0)*YawLeftRate;
 else
  controlinputYaw = (aVehicleTurn/16384.0)*YawRightRate;
  
 NewDesiredSpeed = 0;
 
 if(aVehicleSpeedControl<0)
  NewDesiredSpeed = MinSpeed/16384.0*abs(aVehicleSpeedControl);
 
 if(aVehicleSpeedControl>0)
  NewDesiredSpeed = MaxSpeed/16384.0*abs(aVehicleSpeedControl);

 DesiredSpeed = NewDesiredSpeed;
}

defaultproperties
{
     bBot_ShowVehicleLocation=True
     Armor=100
     InitialHitPoints=100
     FullHitPoints=100
     PhysicsType=TerrainFollowing
     PhysicsFlatBottom=True
     OperatingSound=Sound'AmbModern.Looping.engine2'
     CrashingSound=None
     Elasticity=0.000000
     RepairTime=0.000000
     MoverGlideType=MV_GlideByTime
     EncroachDamage=50
     bDamageTriggered=True
}
