//=============================================================================
// WheelComponent.
//=============================================================================
class WheelComponent expands drivable;
var () float MaxSteeringAngle;       // Minimum/maximum angle this wheel will rotate
var () float WheelDiameter;       // diameter of the wheel. Circular wheel will travel pi*diameter per revolution.

simulated function RotationPhysics(float deltatime)
{
 if(MainDrivable!=self) {
  CurrentRotation.yaw=MaxSteeringAngle*MainDrivable.ControlInputYaw/MAX(MainDrivable.YawRightRate,MainDrivable.YawLeftRate);
  CurrentRotation.roll=MainDrivable.CurrentSpeed*deltatime/WheelDiameter/pi*65536.0;
 }
}

simulated function DoPhysics(float DeltaTime)
{
}

defaultproperties
{
     MaxSteeringAngle=8192.000000
     WheelDiameter=30.000000
     PhysicsType=StaticMover
     PhysicalRotationRate=(Pitch=16384,Yaw=16384,Roll=16384)
}
