//=============================================================================
// VehicleHUD.
//=============================================================================
// Basic 'no frills' HUD to display when a player controls a vehicle.
class VehicleHUD expands HUD;

var VehicleControl vc;

replication
{
 reliable if(Role==ROLE_Authority) vc;
}

simulated function PostRender(canvas  Canvas)
{
 local string FireStatus;

 if(vc==None) 
  return;
  
 Canvas.SetPos(0.5 * Canvas.ClipX - 8, 0.5 * Canvas.ClipY - 8 );
 Canvas.Style = 2;
 Canvas.DrawIcon(Texture'UnrealShare.Icons.Crosshair1', 1.0);
 
 Canvas.Style = 1;
 Canvas.Font = canvas.smallfont;

 Canvas.SetPos(Canvas.ClipX*0.55,Canvas.ClipY*0.5); // show elevation
 Canvas.DrawText("P:" $ int(vc.ReportedRotationPitch*10)/10);

 Canvas.SetPos(Canvas.ClipX*0.5,Canvas.ClipY*0.55); // show yaw
 Canvas.DrawText("Y:" $ int(vc.ReportedRotationYaw*10)/10);

 Canvas.SetPos(Canvas.ClipX*0.55,Canvas.ClipY*0.55); // show roll
 Canvas.DrawText("R:" $ int(vc.ReportedRotationRoll*10)/10);

 Canvas.SetPos(Canvas.ClipX*0.5,Canvas.ClipY*0.6); // show speed
 Canvas.DrawText("V:" $ int(vc.reportedspeed*10)/10);

 Canvas.SetPos(Canvas.ClipX*0.5,Canvas.ClipY*0.65); // show fire status (block)
 if(vc.ReportedProjectileLoaded) 
  firestatus="* ";
 else
  firestatus="- ";

 if(vc.ReportedAltProjectileLoaded) 
  firestatus=firestatus $ "*";
 else
  firestatus=firestatus $ "-";
  
 Canvas.DrawText(firestatus);
 
 if(vc.RadarRange>0.0 && vc.radaractor!=None) {
  canvas.SetPos(Canvas.ClipX*0.5-8,Canvas.ClipY*0.1-8);
  canvas.DrawIcon(texture'UnrealShare.Icons.IconSelection',1.0);  // background
  RenderRadar(Canvas,Canvas.ClipX*0.5,Canvas.ClipY*0.1,Canvas.ClipX*0.1,Canvas.ClipY*0.1);
 }
}

// atan2 determines 360 degree angle (between -pi and Pi, more precisely)
final simulated function float atan2(float Y,float X)
{
 local float tempang;
 
 if(X==0) {
  if(Y<0)
   tempang=-pi/2;
  else if(Y>0)
   tempang=pi/2;
  else
   tempang=0;
 }
 else if(X<0) {
  tempang=atan(Y/X)+pi; // Third quadrant
 }
 else 
  tempang=atan(Y/X);        // 
   
 if(tempang>pi) 
  tempang-=pi*2;
 
 if(tempang<-pi)
  tempang+=pi*2;
   
 return tempang;
}

final simulated function vector VirtualLocation(vector oldpoint,rotator rotateby)
{
 local vector temppoint;
 local rotator temprot;
 local float dist;
 local float axisdist;
 local float axisangle;
 
 temppoint=oldpoint;
 dist = VSize(temppoint);
 temppoint = temppoint/dist; // unity vector, requires less calculations
 
// rotate around Z-axis (Yaw) 
 axisangle = atan2(temppoint.Y,temppoint.X);
 axisdist  = sqrt(square(temppoint.Y)+square(temppoint.X));
 temppoint.Y= sin(axisangle-(RotateBy.Yaw*pi)/32768.0)*axisdist;
 temppoint.X= cos(axisangle-(RotateBy.Yaw*pi)/32768.0)*axisdist;
 
// rotate around Y-axis (Pitch)
 axisangle = atan2(temppoint.Z,temppoint.X);
 axisdist  = sqrt(square(temppoint.Z)+square(temppoint.X));
 temppoint.Z= sin(axisangle-(RotateBy.Pitch*pi)/32768.0)*axisdist;
 temppoint.X= cos(axisangle-(RotateBy.Pitch*pi)/32768.0)*axisdist;

// rotate around X-axis (Roll)
 axisangle = atan2(temppoint.Z,temppoint.Y);
 axisdist  = sqrt(square(temppoint.Z)+square(temppoint.Y));
 temppoint.Z= sin(axisangle+(RotateBy.Roll*pi)/32768.0)*axisdist;
 temppoint.Y= cos(axisangle+(RotateBy.Roll*pi)/32768.0)*axisdist;
 
 temprot=rotateby;
 temprot.Roll=0;
 temprot.Pitch=0;
 
 return vector(rotator(temppoint))*dist; // add origin and distance again
}

simulated function RenderRadar(canvas  Canvas,int BaseX,int BaseY,int Width,int Height)
{
 local drivable drv;
 local pawn pwn;
 local projectile prj;
 local vector relativelocation;
 
 if(vc.RadarActor==None)
  return;
  
 foreach visiblecollidingactors(class'drivable',drv,vc.radarrange,vc.radaractor.location,true) {
  if(drv.currentcontroller!=vc) {
   relativelocation=drv.location-vc.radaractor.location;
   relativelocation=VirtualLocation(relativeLocation,vc.radaractor.rotation);
   Canvas.SetPos(BaseX+(Width/2*relativelocation.Y/vc.radarrange),BaseY-(Height/2*relativelocation.X/vc.radarrange));
   Canvas.DrawIcon(Texture'UnrealShare.Icons.Crosshair3',1.0);
  }
 }
 if(vc.bRadarShowsPawns) {
  foreach visiblecollidingactors(class'pawn',pwn,vc.radarrange,vc.radaractor.location,true) {
   relativelocation=pwn.location-vc.radaractor.location;
   relativelocation=VirtualLocation(relativeLocation,vc.radaractor.rotation);
   Canvas.SetPos(BaseX+(Width/2*relativelocation.Y/vc.radarrange),BaseY-(Height/2*relativelocation.X/vc.radarrange));
   Canvas.DrawIcon(Texture'UnrealShare.Icons.Crosshair3',1.0);
  }
 }
 if(vc.bRadarShowsProjectiles) {
  foreach visiblecollidingactors(class'projectile',prj,vc.radarrange,vc.radaractor.location,true) {
   relativelocation=pwn.location-vc.radaractor.location;
   relativelocation=VirtualLocation(relativeLocation,vc.radaractor.rotation);
   Canvas.SetPos(BaseX+(Width/2*relativelocation.Y/vc.radarrange),BaseY-(Height/2*relativelocation.X/vc.radarrange));
   Canvas.DrawIcon(Texture'UnrealShare.Icons.Crosshair3',1.0);
  }
 }
}

defaultproperties
{
}
