//=============================================================================
// VehicleControl.
//=============================================================================
class VehicleControl expands Pickup;

enum ControllerType {  
 Boat,                                    // A boat can turn, but not strafe, and can only move in a plane
 Car,                                     // A car can turn, not strafe, but can follow the terrain
 Helicopter,                              // A helicopter (when airborne) can change altitude, strafe, move, turn
 Airplane,                                // An airplane cannot hover and strafe, can move in 3D
 HoverCraft,                              // A hovercraft can turn
 Tank,                                    // A tank can turn in place (and crush people)
 Stationary,                              // Non-movable (e.g. turret, in that case, combine with bTurretAvailable=true)
 Crane                                    // A crane uses the fire/altfire functions for grabbing/releasing cargo
};
var () ControllerType VehicleType; // for bots: allows them to use specialized code
var () bool bTurretAvailable;      // for bots: tells them the vehicle has a slaved turret they can control
var () bool bTurretAutoAim;        // for bots: tells them that they don't need to manually move the turret 
var () float ControlFactor;
var () name ControlledTag;
var () name ViewFromTag;
var () name BallisticsTag;
var () name RadarTag;
var () float RadarRange;
var () bool bRadarShowsPawns;
var () bool bRadarShowsProjectiles;
var () bool bStationaryController;
var () bool bPlayersOnly;          // disable ANY bot from picking this up (including ones with a DriversLicense
var () bool bPlayerHasWeapons;
var () bool bPlayerCanLook;
var () bool bPlayerGivesAmmo;
var () bool bPlayerCrouch;
var () class<VehicleHUD> VehicleHUDType;

var VehicleHUD VehicleHUD;
var Actor RadarActor;
var rotator PlayerViewRotation;

var VehicleControl StationaryController; // used to determine if we're still being held

var vector CurrentLocation;
var float ReportedRotationYaw,ReportedRotationPitch,ReportedRotationRoll;
var vector ReportedVehicleLocation,ReportedTurretLocation;
var rotator ReportedVehicleRotation,ReportedTurretRotation;
var bool ReportedProjectileLoaded,ReportedAltProjectileLoaded;
var vector CurrentCrosshairLocation;
var rotator CurrentRotation;
var float reportedspeed;

var actor locationholder;

var actor PlayerViewTarget;
var actor ViewTarget;

// variables the drivables will inspect. The player class must fill these in its playerinput function,
// and that should be done using the ControlVehicle function.
// Bots will fill these directly.
var bool CtlbFire,CtlbAltFire;
var float CtlaVehicleSpeedControl,CtlaTurretTurn;
var float CtlaVehicleTurn,CtlaVehicleUp,CtlaTurretUp;

replication
{
	reliable if(Role==ROLE_Authority)
//	    bShowPitch,bShowYaw,bShowRoll,bShowSpeed,crosshair,
//	    reportedrotationyaw,reportedrotationpitch,reportedrotationroll,reportedspeed,
	    playerviewrotation;//,currentlocation,currentrotation,bPlayerCanLook;
	unreliable if(Role<ROLE_Authority)
	    ControlVehicle;
}

////////////////////////////////////////////////////////////////////////////////////////////////
function ControlVehicle(bool bFire,bool bAltFire,
                        float aForward,float aTurn,float aStrafe,float aUp,float aLookUp)
{
 CtlbFire=bFire;
 CtlbAltFire=bAltFire;
 

   CtlaTurretTurn=aTurn*ControlFactor;
   CtlaTurretUp=aLookup*ControlFactor;
   CtlaVehicleSpeedControl=aForward*ControlFactor;
   CtlaVehicleTurn=aStrafe*ControlFactor;
   CtlaVehicleUp=aUp*ControlFactor;
}

simulated function BeginPlay()
{
 local actor act;
 
 Currentlocation = location;
 CurrentRotation = rotation;
 LocationHolder=spawn(class'DrivableFeedback');
 VehicleHUD=Spawn(VehicleHUDType);
 if(VehicleHUD!=None)
  VehicleHUD.vc=self;

 if(ViewFromTag!='')
  foreach AllActors( class 'Actor', act, ViewFromTag ) 
   if(act!=None) 
    ViewTarget=act;

 if(RadarTag!='')
  foreach AllActors( class 'Actor', act, RadarTag ) 
   if(act!=None) 
    RadarActor=act;
  
 super.beginplay();
}
    

simulated function Activation()
{
 local drivable Drv;
 local actor act;
 local playerpawn user;
 local VehicleRepairKit repairkit;

 if(StationaryController!=None) {
  owner.setbase(none);
//  owner.movesmooth(CurrentLocation-owner.location);
  owner.setlocation(currentlocation);
 }
  
 bActive = true;

 user=playerpawn(owner);
 if(user!=None) {
  PlayerViewTarget=user.ViewTarget;
  user.ViewTarget=viewtarget;
 }

 owner.bRotateToDesired = false;
 if ( ControlledTag != '' ) {
  foreach AllActors( class 'Drivable', Drv, ControlledTag )
  {
   if (Drv != None) {
    if(Drv.CurrentController==None) {
     Drv.controllingplayer = pawn(Owner);
     Drv.CurrentController = self;
    }
   }
  }
  foreach AllActors( class 'Drivable', Drv, ControlledTag )
  {
   if (Drv != None) {
    if(Drv.CurrentController==self) {
     repairkit=vehiclerepairkit(pawn(owner).FindInventoryType(Class'drivable.VehicleRepairKit'));
     if(Drv.bDestroyed) {
      if(repairkit!=None && Drv.bRepairable && !Drv.bRepairing) {
       if(playerpawn(owner)!=None) 
        playerpawn(owner).clientmessage("Repairing: " $ Drv.Tag);
        
       repairkit.GotoState('Activated');
       Drv.GotoState('Repairing');
      }
     }
     else
      Drv.GotoState('Activated');
    }
   }
  }
 }
}

simulated function Deactivation()
{
 local drivable Drv;
 local playerpawn user;

 bActive=false;
 
 CtlbFire=false;
 CtlbAltFire=false;
 CtlaVehicleSpeedControl=0;
 CtlaTurretTurn=0;
 CtlaVehicleTurn=0;
 CtlaVehicleUp=0;
 CtlaTurretUp=0;

 if(owner!=None && bStationaryController) {
//  owner.SetCollision(true,true,true);
//  owner.bcollidewhenplacing=false;
 }

 user=playerpawn(owner);
 if(user!=None) 
  user.ViewTarget = PlayerViewTarget;
  
 if(Owner!=None) {
//  Owner.Velocity=vect(0,0,0);
 }
 if ( ControlledTag != '' )
  foreach AllActors( class 'Drivable', Drv, ControlledTag )
  {
   if (Drv != None) {
   if(Drv.currentcontroller == Self) {
	  Drv.controllingplayer = None;
	  Drv.currentcontroller = None;
	  Drv.GotoState('Deactivated');
   }
  }
 }
}

function bool HandlePickupQuery(inventory item)
{
 if(VehicleControl(item)!=None) {  // any pawn can have only one stationary vehiclecontrol - but may carry multiple remotes
  if(bStationaryController) 
   if(vehiclecontrol(item).bStationarycontroller)
    return true;
 
  return false;
 }
 if(inventory!=None)
  return inventory.HandlePickupQuery(item);
 
}

state Activated
{
	function BeginState()
	{
	 SetPhysics(PHYS_None);
	 SetCollision(false,false,false);
     Activation();
    }


	function EndState()
	{
	 Deactivation();
	 SetPhysics(PHYS_None);
	 SetCollision(true,true,true);
	} 
}

auto state Pickup
{	
	function Touch( actor Other )
	{
		local Inventory Copy;
		if ( ValidTouch(Other) ) 
		{
			Copy = SpawnCopy(Pawn(Other));
			if (Level.Game.LocalLog != None)
				Level.Game.LocalLog.LogPickup(Self, Pawn(Other));
			if (Level.Game.WorldLog != None)
				Level.Game.WorldLog.LogPickup(Self, Pawn(Other));
			if (bActivatable && Pawn(Other).SelectedItem==None) 
				Pawn(Other).SelectedItem=Copy;
			// don't autoactivate
			Pawn(Other).ClientMessage(PickupMessage, 'Pickup');	// add to inventory and run pickupfunction	
			PlaySound (PickupSound,,2.0);	
			Pickup(Copy).PickupFunction(Pawn(Other));
		}
	}

	// Validate touch, and if valid trigger event.
	function bool ValidTouch( actor Other )
	{
		local Actor A;
		local driverslicense lic;

        if(bStationaryController && StationaryController!=None)
         return false;
        
        if(pawn(other)==None)
         return false;
        
        if(bPlayersOnly && PlayerPawn(other)==None)
         return false;
         
        // this check is done here to prevent non-drivers from having their inventory scrolled
        lic=driverslicense(pawn(other).FindInventoryType(class'DriversLicense'));
        
        if(lic==None) { // pawn obviously does not know vehiclecontrols
//         log("pawn does not have a driver's license");
         return false;
        }
         
        if(!bStationaryController && !lic.bUnderstandsRemotes)
         return false;
        
		if( Other.bIsPawn && (Pawn(Other).Health > 0))
		{
		    if(!pawn(other).inventory.HandlePickupQuery(self)) {
		    
 			 if( Event != '' )
			 	 foreach AllActors( class 'Actor', A, Event )
				 	 A.Trigger( Other, Other.Instigator );
 			 return true;
 			}
		}
		return false;
	}

	function BeginState()
	{
		Super.BeginState();
//		bCollideWorld=false;
		if(bStationaryController)
		 MaxDesireability=0;
		 
		NumCopies = 0;
	}
}

state Deactivated
{
 
}

function DropFrom(vector ownerlocation)
{
  if(stationarycontroller!=None) {
   stationarycontroller.destroy();
   stationarycontroller=None;
  }
  super.DropFrom(ownerlocation);
  
  if(bStationaryController) {
   SetLocation(CurrentLocation);
   SetRotation(CurrentRotation);
  }
  if(bActive)
   Deactivation();
  
}

function bool StillBeingHeld(pawn user)
{
 local pawn collides;
 
 foreach touchingactors(class'pawn',collides) {
  if(collides==user)
   return true;
 }
 return false;
}

simulated function UpdateLocation()
{
 if(bStationaryController) {
//  setlocation(CurrentLocation);
//  setrotation(CurrentRotation);
//  if(owner!=None && bActive)
//   owner.SetCollision(false,true,true);
 }
 if(bActive) {
  if(!bPlayerCanLook && bStationaryController) {
   if(playerpawn(owner)!=None)
    if(playerpawn(owner).viewtarget==None)
     pawn(Owner).ViewRotation=CurrentRotation;
    else
     pawn(Owner).ViewRotation=playerpawn(owner).viewtarget.Rotation;

   pawn(Owner).SetRotation(CurrentRotation);
  }
 }
// if(Role==ROLE_Authority) {
  if(stationarycontroller!=None) {
   if(bActive) {
//    Owner.SetBase(none);
//    owner.velocity=velocity;
    Owner.Velocity=vect(0,0,0);
//    owner.bcollidewhenplacing=false;
    owner.MoveSmooth(Location-owner.location);
//    owner.setlocation(location);
    owner.SetBase(Base);
   }

   stationarycontroller.setlocation(location);
   stationarycontroller.setrotation(rotation);
   if(StationaryController!=None) {
    if(!stationarycontroller.StillBeingHeld(pawn(owner))) 
     if(!bActive) {
       DropFrom(location);
     }
   }
  }
// }
}
// Controllers don't respawn - but stationary controllers leave one copy for checking if they are still in reach
function inventory SpawnCopy( pawn Other )
{
	local inventory Copy;
    
	Copy = self;

	Copy.RespawnTime = 0.0;
	Copy.bHeldItem = true;
	Copy.GiveTo( Other );
	if(bStationaryController) {
	 StationaryController=spawn(class'VehicleControlRefCpy');
	 StationaryController.bStationaryController=true;
	 StationaryController.GotoState('ReferenceLocation');
	 StationaryController.drawtype = DT_None;
	 StationaryController.SetCollision(true,false,false);
	 StationaryController.SetCollisionSize(collisionradius,collisionheight);
	}
	return Copy;
}

function bool FindAmmo(class AmmoName, int count) // gets ammo from controlling player 
{
 local Ammo AmmoType;
 local Pickup PickupType;
 
 if(bPlayerGivesAmmo==false)
  return false;
  
 if ( AmmoName == None )
  return false;

 AmmoType = Ammo(pawn(Owner).FindInventoryType(AmmoName));
 if ( AmmoType != None ) 
  return AmmoType.UseAmmo(count);

 return false;
}	

//MWP:begin
// overridable function to ask the inventory object to draw its StatusIcon
simulated function DrawStatusIconAt( canvas Canvas, int X, int Y, optional float Scale )
{
	if( Scale == 0.0 )
		Scale = 1.0;
	Canvas.SetPos( X, Y );
	Canvas.DrawIcon( StatusIcon, Scale );

}
//MWP:end

simulated function PostRender(canvas  Canvas)
{
 if(VehicleHUD==None)
  return;
  
 VehicleHUD.PostRender(Canvas);
} 

function BallisticCalculation(float latitude,float longitude,float altitude,out float Yaw,out float HighTraj,out float flighttime)
{
 local Drivable Drv;
 
 if ( ControlledTag != '' )
		foreach AllActors( class 'Drivable', Drv, BallisticsTag )
		{
			if (Drv != None) {
			 if(Drv.CurrentController==Self && Drv.bDoesBallisticCalculation) {
 			  Drv.BallisticCalculation(latitude,longitude,altitude,Yaw,hightraj,flighttime);
 			  return;
 			 }
			}
		}
}

state ReferenceLocation {
 ignores Touch;
}

// Attempts to find a direct route to a destination
// If not available, will try to concatenate paths, depth first (probably slooooooooow)
// (Prime candidate for DLL implementation I'd say)
// Return value: number of paths that need to be followed to get there (1 for direct route, 0 for no route)
function int FindRouteTo(vector start,vector destination, out DrivablePathNode startnode, out int EndSequence, float maxdistance,optional int depth)
{
 local actor node;
 local DrivablePathNode destnode, possiblestartnode;
 local int dummyendsequence,childpathcount;
 local bool PathOK;
 
 startnode=None;

 locationholder.setlocation(start);
 
 foreach locationholder.RadiusActors(class'DrivablePathNode',possiblestartnode,maxdistance) {
  PathOK=false;
  switch(VehicleType) {
   case Boat:
    if(possiblestartnode.class==class'DrivablePathNodeWater')
     PathOK=true;
    break;
   case Hovercraft:
    if(possiblestartnode.class==class'DrivablePathNodeWater')
     PathOK=true;
    if(possiblestartnode.class==class'DrivablePathNodeLand')
     PathOK=true;
    break;
   case Airplane:
   case Helicopter:
    if(possiblestartnode.class==class'DrivablePathNodeAir')
     PathOK=true;
    break;
   case Car:
   case Tank:
    if(possiblestartnode.class==class'DrivablePathNodeLand')
     PathOK=true;
    break;
   default:
    break;
  }   
  if(PathOK) {
   foreach AllActors(possiblestartnode.class,node,possiblestartnode.tag) {
    if(VSize(node.location-destination)<=maxdistance) {// direct route to destination
     EndSequence=DrivablePathNode(node).sequence;
     startnode=possiblestartnode;
     return 1;
    }
   }
   if(depth<6) { // Maximum of 6 paths 
    foreach AllActors(possiblestartnode.class,node,possiblestartnode.tag) {
     ChildPathCount=FindRouteTo(node.location,destination,destnode,dummyendsequence,maxdistance,depth+1);
     if(ChildPathCount>0) {
      EndSequence=DrivablePathNode(node).sequence;
      startnode=possiblestartnode;
      return ChildPathCount+1;
     }
    }
   }
  }  
 }
 return 0;
}

function bool MoveVehicle(vector DesiredLocation)
{
 local float requiredyaw,requiredpitch;
 local float flighttime;
  
 requiredyaw=rotator(DesiredLocation-ReportedVehicleLocation).Yaw;
 requiredpitch=rotator(DesiredLocation-ReportedVehicleLocation).pitch;


 switch(VehicleType) {
  case airplane:
   CtlaVehicleTurn=(requiredyaw-reportedvehiclerotation.yaw)/0.2;
   CtlaVehicleUp=(requiredyaw-reportedvehiclerotation.yaw)/0.2;
   CtlaVehicleSpeedControl=16384;
   break;
  case Helicopter:
   CtlaVehicleTurn=(requiredyaw-reportedvehiclerotation.yaw)/0.2;
   CtlaVehicleUp=(requiredyaw-reportedvehiclerotation.yaw)/0.2;
   CtlaVehicleSpeedControl=16384;
   break;
  case HoverCraft:
  case Tank: // tank can turn in-place
   CtlaVehicleTurn=(requiredyaw-reportedvehiclerotation.yaw)/0.2;
   CtlaVehicleSpeedControl=16384;
   break;
  case Car:  // cars and boats need some forward or backward motion in order to turn
  case Boat:
   CtlaVehicleTurn=(requiredyaw-reportedvehiclerotation.yaw)/0.2;
   CtlaVehicleSpeedControl=16384;
   break;
  case stationary:
   break;
  default:
   break;
 }

 if(   abs(reportedvehiclerotation.yaw-requiredyaw)<50
    && abs(reportedvehiclerotation.pitch-requiredpitch)<50)
  return true;
  
 return false;
}

// Note: this can only be used with a DrivableCameraComponent
// Also, if there is no viewfromtag, the bot should use its own vision check
function bool TargetVisibleFromVehicle(actor target)
{
 local DrivableCameraComponent cam;
 local rotator relativeangle;
 local vector Hitlocation,Hitnormal;
 
 cam=DrivableCameraComponent(ViewTarget);
 
 if(cam!=None) {
  if(VSize(target.location-cam.location)<=cam.viewrange) {
   relativeangle=rotator(target.location-cam.location)-cam.rotation;
   if(relativeangle.yaw>=32768)
    relativeangle.yaw -= 65536;
   if(relativeangle.pitch>=32768)
    relativeangle.pitch -= 65536;
   if(abs(relativeangle.pitch)*180/32768<=cam.ViewFOV/2 
    &&abs(relativeangle.yaw)*180/32768<=cam.ViewFOV/2) {
    if(Trace(HitLocation,HitNormal,target.location,cam.location)==target)
     return true;
   }
  }
 }
 return false;
}

simulated function Tick(float DeltaTime)
{
 if(StationaryController!=None) { // basically stick to the original location even when not attached to a drivable
  UpdateLocation();
 } 
}

defaultproperties
{
     ControlFactor=5.000000
     ControlledTag=drivable
     RadarRange=5000.000000
     VehicleHUDType=Class'drivable.VehicleHUD'
     bCanActivate=True
     bActivatable=True
     bDisplayableInv=True
     PickupMessage="Are you some kind of control-freak?"
     ItemName="Drivable"
     PickupViewMesh=LodMesh'UnrealShare.TranslatorMesh'
     Icon=Texture'UnrealShare.Icons.I_Tran'
     bNoDelete=True
     bAlwaysRelevant=True
     bDirectional=True
     Mesh=LodMesh'UnrealShare.TranslatorMesh'
     bIsItemGoal=False
     bTravel=False
     CollisionRadius=15.000000
     CollisionHeight=15.000000
     NetPriority=8.000000
}
