//=============================================================================
// TankHUD.
//=============================================================================
class TankHUD expands VehicleHUD;

simulated function PostRender(canvas  Canvas)
{
 local string FireStatus;
 
 if(vc==None) 
  return;
  
 Canvas.SetPos(0.5 * Canvas.ClipX - 8, 0.5 * Canvas.ClipY - 8 );
 Canvas.Style = 2;
 Canvas.DrawIcon(Texture'UnrealShare.Icons.Crosshair1', 1.0);
 
 Canvas.Style = 1;
 Canvas.Font = canvas.smallfont;

 Canvas.SetPos(Canvas.ClipX*0.5,Canvas.ClipY*0.55); // show yaw
 Canvas.DrawText("Y:" $ int(vc.ReportedRotationYaw*10)/10);

 Canvas.SetPos(Canvas.ClipX*0.5,Canvas.ClipY*0.6); // show speed
 Canvas.DrawText("V:" $ int(vc.reportedspeed*10)/10);

 Canvas.SetPos(Canvas.ClipX*0.5,Canvas.ClipY*0.65); // show fire status (block)
 if(vc.ReportedProjectileLoaded) 
  firestatus="* ";
 else
  firestatus="- ";

 if(vc.ReportedAltProjectileLoaded) 
  firestatus=firestatus $ "*";
 else
  firestatus=firestatus $ "-";
  
 Canvas.DrawText(firestatus);
 
 if(vc.RadarRange>0.0 && vc.radaractor!=None) {
  canvas.SetPos(Canvas.ClipX*0.5-8,Canvas.ClipY*0.1-8);
  canvas.DrawIcon(texture'UnrealShare.Icons.IconSelection',1.0);  // background
  RenderRadar(Canvas,Canvas.ClipX*0.5,Canvas.ClipY*0.1,Canvas.ClipX*0.1,Canvas.ClipY*0.1);
 }
}

defaultproperties
{
}
