//=============================================================================
// SwingingDoor.
//=============================================================================
// Looking in de direction of the arrow, positive rotation is to the right
class SwingingDoor expands drivable;
var () bool bBumpToOperate;
var () int  SwingAngle;
var () float OpenTime;
var () float CloseTime;
var () float StayOpenTime;
var () bool  bActivateToggles;   // if true, activating the door toggles between open and close
                                // if false, activating the door opens it, deactivating closes 
var bool bWantOpen;
var float currentangle;
var bool bTiming;

replication
{
 reliable if(Role==ROLE_Authority)
            currentangle;
}

event Bump( Actor Other )
{
 if(bBumpToOperate) {
  bWantOpen = !bWantOpen;
  bTiming=false;
  SetTimer(0,false);
  bTiming=false;
 }
}

state Deactivated
{
 function BeginState()
 {
  if(!bActivateToggles)
   bWantOpen=false;
 }
}

function Timer()
{
 bTiming=false;
 bWantOpen=false;
}

state Activated
{
 function BeginState()
 {
  if(bActivateToggles) {
   bWantOpen= !bWantOpen;
   bTiming=false;
   SetTimer(0,false);
   if(currentcontroller!=None)
    CurrentController.GotoState('Deactivated');
   GotoState('Deactivated');
  }
  else
   bWantOpen=true;
 }
}

simulated function rotator CalculateOwnRotation()
{
 local rotator temprot;
 
 temprot=rot(0,0,0);
 temprot.roll=currentangle;
 
 return RealWorldRotation(RealWorldRotation(temprot,CurrentRotation),planeangles);
}

simulated function DoPhysics(float DeltaTime)
{
}

simulated function RotationPhysics(float DeltaTime)
{
 if(bWantOpen) {
  if(currentangle<swingangle)
   currentangle+=swingangle*deltatime/OpenTime;
  else 
  if(!bTiming && bActivateToggles) { // If not completely open and toggle behaviour has been chosen
   currentangle=swingangle;
   bTiming=true;
   SetTimer(StayOpenTime,false);
  }
 }
 else {
  if(currentangle>0)
   currentangle-=swingangle*deltatime/CloseTime;
  else
   currentangle=0;
 }
}

defaultproperties
{
     bBumpToOperate=True
     SwingAngle=16384
     OpenTime=1.000000
     CloseTime=1.000000
     StayOpenTime=1.000000
     bActivateToggles=True
     Armor=99999
     PhysicalRotationRate=(Pitch=0,Yaw=0,Roll=0)
     CrashingSound=None
     DestroyedSound=None
     bRepairable=False
     RepairTime=0.000000
     bIndependent=True
     MoverEncroachType=ME_ReturnWhenEncroach
     MoverGlideType=MV_GlideByTime
     BumpType=BT_PawnBump
     bBounce=True
     bFixedRotationDir=False
}
