//=============================================================================
// SlidingDoor.
//=============================================================================
class SlidingDoor expands drivable;
var () bool bBumpToOperate;
var () float Slidedistance;
var () float OpenTime;
var () float CloseTime;
var () float StayOpenTime;
var () bool  bActivateToggles;   // if true, activating the door toggles between open and close
                                // if false, activating the door opens it, deactivating closes 
var bool bWantOpen;
var float currentdistance;
var bool bTiming;

replication
{
 reliable if(Role==ROLE_Authority)
  currentdistance;
}

event Bump( Actor Other )
{
 if(bBumpToOperate) {
  bWantOpen = !bWantOpen;
  bTiming=false;
  SetTimer(0,false);
 }
}

state Deactivated
{
 function BeginState()
 {
  if(!bActivateToggles)
   bWantOpen=true;
 }
}

function Timer()
{
 bTiming=false;
 bWantOpen=false;
}

state Activated
{
 function BeginState()
 {
  if(bActivateToggles) {
   bWantOpen= !bWantOpen;
   bTiming=false;
   SetTimer(0,false);
   if(currentcontroller!=None)
    CurrentController.GotoState('Deactivated');
   GotoState('Deactivated');
  }
  else
   bWantOpen=true;
 }
}

simulated function vector CalculateOwnLocation()
{
 local vector tempdist;
 
 tempdist=vect(0,0,0);
 tempdist.X=currentdistance;
 
 return RealWorldLocation(RealWorldLocation(tempdist,currentrotation)+CurrentLocation,planeangles)+Origin;
}

simulated function DoPhysics(float DeltaTime)
{
 if(bWantOpen) {
  if(abs(currentdistance)<abs(slidedistance))
   currentdistance+=slidedistance*deltatime/OpenTime;
  else 
  if(!bTiming && bActivateToggles) {
   currentdistance=slidedistance;
   bTiming=true;
   SetTimer(StayOpenTime,false);
  }
 }
 else {
  if(currentdistance*slidedistance>0) // multiplied as trick to make this positive
   currentdistance-=slidedistance*deltatime/CloseTime;
  else
   currentdistance=0;
 }
}

simulated function RotationPhysics(float DeltaTime)
{
}

defaultproperties
{
     bBumpToOperate=True
     Slidedistance=64.000000
     OpenTime=1.000000
     CloseTime=1.000000
     StayOpenTime=5.000000
     bActivateToggles=True
     Armor=99999
     PhysicalRotationRate=(Pitch=0,Yaw=0,Roll=0)
     CrashingSound=None
     DestroyedSound=None
     bRepairable=False
     RepairTime=0.000000
     bIndependent=True
     MoverGlideType=MV_GlideByTime
}
