//=============================================================================
// PropellorComponent.
//=============================================================================
class PropellorComponent expands drivable;
var () float MaxRevsPerSecond; // how quickly the propellor will rotate
var () bool bConstantSpeed;

// propellor only rotates. the actual propulsion is handled by drivablefeedbacks and the
// main drivable
simulated function DoPhysics(float DeltaTime)
{
}

simulated function RotationPhysics(float deltatime)
{
 if(MainDrivable!=self) {
  if(bConstantSpeed) 
   CurrentRotation.roll+=MaxRevsPerSecond*65536.0*deltatime;
  else
   CurrentRotation.roll+=MaxRevsPerSecond*MainDrivable.DesiredSpeed/MainDrivable.MaxSpeed*65536.0*deltatime;
 }
}

defaultproperties
{
     MaxRevsPerSecond=10.000000
     PhysicsType=StaticMover
     PhysicalRotationRate=(Pitch=16384,Yaw=16384,Roll=16384)
     Mesh=LodMesh'UnrealShare.Fan2M'
}
