//=============================================================================
// Plane.
//=============================================================================
class Plane expands Drivable;
var () float TakeOffSpeed;
var () float MaxAirSpeed;
var float LiftPerSpeedUnit; 
var () float AirAcceleration;
var () float AirDrag;
var () bool RudderAvailable; // if not enabled, only rolling will turn the aircraft
var bool OnGround;

// plane uses look for pitch/roll. Use strafe for rudder control, forward/backward for throttle.
simulated function InterpretControls(bool bJustFired,bool bFire,bool bJustAltFired,bool bAltFire,
                           float aVehicleSpeedControl,float aTurretTurn,float aVehicleTurn,
                           float aVehicleUp,float aTurretUp,bool bJustJumped,bool bJustDucked)
{
 if(aVehicleTurn<0)
  controlinputRoll = (aVehicleTurn/16384.0)*RollLeftRate;
 else
  controlinputRoll = (aVehicleTurn/16384.0)*RollRightRate;

 if(RudderAvailable) {
  if(aTurretTurn<0)
   controlinputYaw = (aTurretTurn/16384.0)*YawLeftRate;
  else
   controlinputYaw = (aTurretTurn/16384.0)*YawRightRate;
 }
 else
  controlinputYaw=0.0;

 if(aTurretUp<0)
  controlinputPitch = (aTurretUp/16384.0)*PitchDownRate;
 else
  controlinputPitch = (aTurretUp/16384.0)*PitchUpRate;
  
 if(aVehicleSpeedControl<0)  // accelerating means pushing the nose down, not up, so inverted
  ControlInputPitch = -(aVehicleSpeedControl/16384.0)*PitchUpRate;
 else
  ControlInputPitch = -(aVehicleSpeedControl/16384.0)*PitchDownRate;
 
 DesiredSpeed = Max(0,Min(MaxSpeed,DesiredSpeed+aVehicleUp/16384.0*MaxSpeed));
}

// plane only has translational lift (lift through speed).

simulated function DoPhysics(float DeltaTime)
{
 local vector force;
 local vector tempvel,templocation,O,N,HitLocation,HitNormal;
 local rotator temprot;
 local actor groundobject;
 local float lift,drag,acceleration;
 
 if(groundfeedbackindex<0)
  return;

 PreviousLocation=CurrentLocation;
 
 acceleration=Max(DesiredSpeed-CurrentSpeed,0)/MaxSpeed*AirAcceleration;
 drag=sin(CurrentRotation.Pitch/32768.0*pi)*AirDrag;
  
 tempvel=virtuallocation(linearvelocity,rotation);
 
 if(passengerof==None)
  tempvel += virtuallocation(passengerof.velocity,rotation);

 lift=tempvel.X*LiftPerSpeedUnit;

 force=RealWorldLocation(vect(0,0,1)*lift*mass,CurrentRotation); // translational lift
 force+=region.zone.zonegravity*mass;
 
 if(!OnGround && tempvel.X< TakeOffSpeed) { // check if we're now on the ground
  TempLocation    = Feedback[groundfeedbackindex].originoffset;
  TempLocation.X=0; 
  TempLocation.Y=0; 
  TempLocation.Z+=2;
  N=CurrentLocation+RealWorldLocation(RealWorldLocation(TempLocation,CurrentRotation),planeangles);
  TempLocation    = Feedback[groundfeedbackindex].originoffset;
  TempLocation.X=0; 
  TempLocation.Y=0; 
  TempLocation.Z-=2;
  O=CurrentLocation+RealWorldLocation(RealWorldLocation(TempLocation,CurrentRotation),planeangles);
  if(passengerof!=None) {
    N=RealWorldLocation(N,passengerof.rotation)+passengerof.location;
    O=RealWorldLocation(O,passengerof.rotation)+passengerof.location;
  }
  groundobject=Trace(HitLocation,HitNormal,O,N,false);
  while(drivable(groundobject)==Self) {
   groundobject=Trace(HitLocation,HitNormal,O,HitLocation+normal(O-HitLocation),false);
  }
  if(GroundObject!=None && groundobject!=self) 
   OnGround=true;
 }
 else {
  if(tempvel.X>TakeOffSpeed)
   OnGround=false;
 }
 if(OnGround) {
  super.DoPhysics(deltatime);
  return;
 }

// From here on, specific plane physics
 LastGoodLocation=CurrentLocation;
 LastGoodRotation=CurrentRotation;
 
 drag=AirDrag; //sin(CurrentRotation.Pitch/32768*pi)*AirDrag*tempvel.X/MaxSpeed;
 // the next calculation basically translates the 'percentage' input to a percentage of maxairspeed
 // so you still choose a speed with you forward axis
 acceleration=max(0,min(AirAcceleration,max(DesiredSpeed,0)/MaxSpeed*MaxAirSpeed-CurrentSpeed));

 LinearVelocity=RealWorldLocation(vect(1,0,0)*CurrentSpeed,currentrotation);
 CurrentLocation+=(LinearVelocity)*deltatime;
 CurrentSpeed+=(acceleration-drag)*deltatime;
 if(CurrentSpeed>MaxAirSpeed)
  CurrentSpeed=MaxAirSpeed;
 if(CurrentSpeed<0)
  CurrentSpeed=0;

 if(tempvel.X<TakeOffSpeed) {// make sure that lack of lift results in drop
  LinearVelocity+=force/mass*deltatime;
 }
 templocation= VirtualLocation(region.zone.zonegravity,currentrotation)+vect(0,0,1)*lift;
 temprot=rot(0,0,0);
// temprot.pitch=32768.0*atan2(templocation.Z,(CurrentSpeed-TakeOffSpeed))*cos(CurrentRotation.roll/32768.0*pi);
 temprot.yaw=CurrentSpeed/TakeOffSpeed*sin(CurrentRotation.roll/32768.0*pi)*YawLeftRate*deltatime;
// if(temprot.Pitch>physicalrotationrate.pitch*deltatime)
//  temprot.pitch=physicalrotationrate.pitch*deltatime;
 if(temprot.Yaw>physicalrotationrate.yaw*deltatime)
  temprot.yaw=physicalrotationrate.yaw*deltatime;
// if(temprot.Pitch<-physicalrotationrate.pitch*deltatime)
//  temprot.pitch=-physicalrotationrate.pitch*deltatime;
 if(temprot.Yaw<-physicalrotationrate.yaw*deltatime)
  temprot.yaw=-physicalrotationrate.yaw*deltatime;
//  
 CurrentRotation += temprot;
 
// cap the speed
// LinearVelocity=max(1,VSize(LinearVelocity)/MaxAirSpeed)*LinearVelocity;
   
// Check for collision        ------- when hitting something, the plane will be damaged!
 if(CheckForCollision(deltatime)) {
  CurrentLocation = PreviousLocation;
  gravityinducedvelocity=vect(0,0,0);
  CurrentRotation = PreviousRotation;
  linearvelocity=-linearvelocity;
// TakeDamage(   )
 } 
}
  
simulated function RotationPhysics(float DeltaTime)
{
 local rotator NewRotation;
 local float compensationYaw,compensationPitch,compensationRoll; // not using rotator because these values are generally<1
 
 if(DeltaTime<=0)
  return;

 if(OnGround) {
  super.RotationPhysics(DeltaTime);
  return;
 }
  
 PreviousRotation = CurrentRotation;
 CurrentRotation.Roll=normalizeangle(CurrentRotation.Roll);
 CurrentRotation.Pitch=normalizeangle(CurrentRotation.Pitch);
 CurrentRotation.Yaw=normalizeangle(CurrentRotation.Yaw);
 
 NewRotation = CurrentRotation;
  
 if(currentcontroller != None) {  
  compensationYaw=ControlInputYaw*deltatime;
  compensationPitch=ControlInputPitch*deltatime;
  compensationRoll=ControlInputRoll*deltatime; 
 } 
 NewRotation.Roll  += CompensationRoll;
 NewRotation.Pitch += cos(NewRotation.Roll/32768.0*pi)*compensationPitch-sin(NewRotation.Roll/32768.0*pi)*compensationyaw*airtraction;
 NewRotation.Yaw   += sin(NewRotation.Roll/32768.0*pi)*compensationPitch+cos(NewRotation.Roll/32768.0*pi)*compensationYaw*airtraction;

 NewRotation.Roll = normalizeangle(NewRotation.Roll);  
 NewRotation.Pitch = normalizeangle(NewRotation.Pitch);  
 NewRotation.Yaw = normalizeangle(NewRotation.Yaw);  

 // if CurrentRotation will change, play rotatingsound

 CurrentRotation = NewRotation; 
}

simulated function PostBeginPlay()
{
 LiftPerSpeedUnit=VSize(region.zone.zonegravity)/TakeOffSpeed;
 super.PostBeginPlay();
}

defaultproperties
{
     TakeOffSpeed=100.000000
     MaxAirSpeed=400.000000
     AirAcceleration=150.000000
     AirDrag=50.000000
     bHUD_ShowsPitch=True
     bHUD_ShowsYaw=True
     bHUD_ShowsRoll=True
     bHUD_ShowsSpeed=True
     bBot_ShowVehicleLocation=True
     Armor=50
     InitialHitPoints=100
     FullHitPoints=100
     DestructionEffect=None
     PhysicsType=TerrainFollowing
     PhysicalRotationRate=(Pitch=4096,Yaw=4096,Roll=4096)
     CrashingSound=None
     DestroyedSound=None
     Elasticity=0.000000
     bRepairable=False
     RepairTime=0.000000
     MoverGlideType=MV_GlideByTime
     bDamageTriggered=True
}
