//=============================================================================
// MaleOneDriverBot.
//=============================================================================
class MaleOneDriverBot expands MaleOneBot;

// Incorporate the following stuff into your player class to support drivables
/////////////////////////////////////////////////////////////////////////////////////////////////////
var bool bDriving;
var VehicleControl activecontroller;
var float BobDefault;
var float MaxStepHeightDefault;
var float altitude,latitude,longitude;
var bool previousbFire,previousbAltFire,previousbjump,previousbduck;
var bool CtlbJustFired,CtlbFire,CtlbJustAltFired,CtlbAltFire;
var float CtlaForward,CtlaTurn;
var float CtlaStrafe,CtlaUp,CtlaLookUp;
var bool CtlbDuck,CtlbJump,CtlbJustDucked,CtlbJustJumped;
var bool bPreviousDriving;

var vector CurrentDrivableDestination;
var VehicleControl CurrentController;
var int LastDrivablePathSequence;
var DrivablePathNode CurrentDrivablePathNode;
var vector DesiredDrivableLocation;

function float AdjustDesireFor(Inventory Inv)
{
 local float desirabilityfactor;
 
 desirabilityfactor=1.0;
 
 if(VehicleControl(inv)!=None && Health>0.5*default.health) {
  if(VehicleControl(inv).bTurretAvailable) // Oh yeah!
   desirabilityfactor=2.0;
  
  switch(VehicleControl(inv).VehicleType) {
   case boat:    // generally less desirable because of speed/manouvrability
    return 0.3*desirabilityfactor;
   case car:
    return 0.4*desirabilityfactor;
   case helicopter:
    return 0.5*desirabilityfactor;
   case airplane:
    return 0.5*desirabilityfactor;
   case hovercraft:
    return 0.4*desirabilityfactor;
   case tank:
    return 0.5*desirabilityfactor;
   case stationary:
    if(VehicleControl(inv).bTurretAvailable) // Oh yeah!
     return 0.8;
    return 0.0; // Don't want to control something that doesn't do anything
   case crane: // Crane is a utility object
    return 0.0;
   default: // if not known, we probably don't want it
    return 0.0;
  }
 }  

 return super.AdjustDesireFor(Inv);
}

function SteerVehicle()
{
 switch(activecontroller.VehicleType) {
  case boat:    // generally less desirable because of speed/manouvrability
   return;
  case car:
   return;
  case helicopter:
   return;
  case airplane:
   return;
  case hovercraft:
   return;
  case tank:
   return;
  default: // if not known, we probably don't want it
   return;
 }
}

state Driving
{

 function ScanForTarget() // Look for a target to shoot at
 {
  local pawn p;
  local vector sightlocation;
  
  sightlocation=location;
  if(activecontroller!=None &&activecontroller.viewtarget!=None)
   sightlocation=activecontroller.viewtarget.location;
  foreach VisibleCollidingActors(class'pawn',p,sightradius,sightlocation,true) {
   if(p!=self) {
    if(AttitudeTo(p)==ATTITUDE_Hate) {
     target=p;
    }
    break;
   }
  }
 }
 
 function bool AimTurret() // aim the turret at the target
 {
  local float requiredyaw,requiredpitch;
  local float flighttime;
  
  CurrentController.BallisticCalculation(Target.Location.X,Target.Location.Y,Target.Location.Z,requiredyaw,requiredpitch,flighttime);
   
  if(Skill>=2.0)  // Try to lead the target - makes the ballistics calculations heavier
   CurrentController.BallisticCalculation(Target.Location.X+target.velocity.X*flighttime,Target.Location.Y+target.velocity.X*flighttime,Target.Location.Y+target.velocity.Z*flighttime,requiredyaw,requiredpitch,flighttime);
  
  CurrentController.CtlaTurretTurn=(requiredyaw-CurrentController.reportedturretrotation.yaw)/0.2;
  CurrentController.CtlaTurretUp=(requiredpitch-CurrentController.reportedturretrotation.pitch)/0.2;

  if(   abs(CurrentController.reportedturretrotation.yaw-requiredyaw)<50
     && abs(CurrentController.reportedturretrotation.pitch-requiredpitch)<50)
   return true;
  
  return false;
 }


 function PickNextWaypoint()
 {
  local int pathcount;

  
  pathcount=CurrentController.FindRouteTo(currentcontroller.reportedvehiclelocation,DesiredDrivableLocation,
                                          CurrentDrivablePathNode,LastDrivablePathSequence,2000);
  if(pathcount==0)
   CurrentDrivablePathNode=None;                                          
 }

 // Determine if the waypoint has been reached. If so, the next node is selected.
 function bool ReachedWaypoint()
 {
  if(CurrentDrivablePathNode==None)
   return true;
   
  if(VSize(CurrentController.ReportedVehicleLocation-CurrentDrivablePathNode.Location)<2000) {
   if(CurrentDrivablePathNode.Sequence==LastDrivablePathSequence)
    return true;
   if(CurrentDrivablePathNode.Sequence<LastDrivablePathSequence)
    CurrentDrivablePathNode=CurrentDrivablePathNode.Next;
   else
    CurrentDrivablePathNode=CurrentDrivablePathNode.Prev;
  }
  return false;
 }
 
 // Determine if the destination has been reached. If not, the next path is selected.
 function bool ReachedDestination()
 {
  if(VSize(CurrentController.ReportedVehicleLocation-DesiredDrivableLocation)<2000) {
 
   return true;
  }
 }
 
 
Begin:
      PickDrivableDestination();
Mainloop:
      Sleep(0.2);
      if(CurrentController.bTurretAvailable) {
       if(Target!=None)
        Goto('AimTurret');
       ScanForTarget();
      }
      if(CurrentController.VehicleType!=Stationary) {
       if(ReachedWaypoint()) {
        if(ReachedDestination()) 
         Goto('DestinationAction');
       
        PickNextWayPoint();
       }
       else {
        SteerVehicle();
       }
      }
      Goto('Mainloop');
AimTurret:
      if(target!=None)
       if(AimTurret()) {
Fire:
        if(currentcontroller.ReportedProjectileLoaded) {
         Sleep(0.1); 
         currentcontroller.CtlbFire=true;
        }
        else
        if(currentcontroller.ReportedAltProjectileLoaded) {
AltFire:
         Sleep(0.1);
         currentcontroller.CtlbAltFire=true;
        }
       }

      Goto('Mainloop');
DestinationAction:
      Sleep(1.0);
      Goto('Begin');
}

// Determine where to go next. Without some kind of orders, this is kind of pointless for a bot, but for now, just try to follow the target.
function PickDrivableDestination()
{

// DesiredDrivableLocation=CurrentController.ReportedVehicleLocation;
 if(target!=None)
  DesiredDrivableLocation=Target.Location;
 
}
 

// this requires some navigation using trace in order to get out of the vehicle. Basically, the bot is considered outside if there is enough room.
state LeavingDrivable
{


}

// when a bot is on a ladder, it needs to know how to climb, and which direction it wants to climb in
state ClimbingLadder
{



}

function Touch(Actor Other)
{
 if(VehicleControl(Other)!=None)
  if(FindInventoryType(class'DriversLicense')==None)
   SpawnLicense();
 Super.Touch(Other);
}

simulated function DeactivateController()
{
 local vehiclecontrol vc;
 
 vc=activecontroller;
 bDriving=false;
 bRotateToDesired = true;
 SetDefaultDisplayProperties();
 if(!activecontroller.bPlayerHasWeapons)
  ShowWeapon();
           
 if(activecontroller.bPlayerCrouch) {
  bDuck=0;
 }
 activecontroller=None;
 if(vc.bStationaryController) {
//  bCollideWorld=true;
//  SetCollision(true,true,true);
  SetPhysics(PHYS_Walking);
//  StartWalk();
 }
}

function DropItem()
{
 local Inventory Inv;
 
	if( Level.NetMode == NM_Client )
		return;
	if( SelectedItem==None || !SelectedItem.bDisplayableInv || !SelectedItem.bActivatable )
		return;
	Inv=selecteditem;
	if(selecteditem.bActive)
	 ActivateItem();
	 
	selecteditem.Velocity = Vector(ViewRotation) * 500 + vect(0,0,220);
	inv.DropFrom(Location);
}

simulated function ActivateController(vehiclecontrol vc)
{
 if(vc.bPlayerCrouch) {
  bDuck=1;
 }
 bDriving = true;
 activecontroller=vc;
  
 if(!vc.bPlayerHasWeapons)
  HideWeapon();
 
 if(vc.bStationaryController) {
//  SetCollision(false,true,true);
  SetPhysics(PHYS_None);
//  bCollideWorld=false;
//  GotoState('Driving');
 }
}

// The bot wants to activate/deactivate selected item
function ActivateItem()
{
	if (vehiclecontrol(SelectedItem)!=None) {
	 if(activecontroller!=None && activecontroller!=selecteditem) {
	  activecontroller.Activate();
	  DeactivateController();
	 }
	  
 	 SelectedItem.Activate();
 	 if(selecteditem.bActive)
  	  ActivateController(vehiclecontrol(selecteditem));
 	 else
 	  DeactivateController();
  	  
 	 return;
 	}
}

// for ballistic fire support
function bool CalcBall(float longitude,float latitude,float altitude,out float Yaw,out float HighTraj,out float flighttime)
{
 if(bDriving) {
  if(activecontroller!=None) {
   activecontroller.BallisticCalculation(latitude*10000+level.location.X,longitude*10000+level.location.Y,altitude*100+level.location.Z,Yaw,hightraj,flighttime);
   return true;
  }
 }

 return false;
}

function OnBeginPlay()
{
 previousbFire=false;
 previousbAltFire=false;
}

function SpawnLicense()
{
 local driverslicense lic;

 lic=spawn(class'DriversLicense');
 if(lic==None)
  log(tag $ "Failed to spawn Driver's License!");
 else {
  lic.bUnderstandsRemotes=true;
  AddInventory(lic);
 }
}

simulated function ChangedWeapon()
{
	if(bDriving) {
	 if(activecontroller!=None)
	  if(activecontroller.bPlayerHasWeapons==false) {
	   return;
	  }
	}
	super.ChangedWeapon();
}

event Destroyed()
{
 dropallvehiclecontrols();
 Super.Destroyed();
}

function Died(pawn instigatedBy, name damageType, vector HitLocation)
{
 dropallvehiclecontrols();
 Super.Died(instigatedBy, damageType, HitLocation);
}

function dropallvehiclecontrols()
{
 local inventory inv;
 local vehiclecontrol v;
 
 // drop all controllers
 if(activecontroller!=none)
  activecontroller.Activate(); // deactivate controller
  
 bDriving=false;
 Activecontroller=none;
 for (inv=Inventory; inv!=None; inv=inv.Inventory) {
  v = vehiclecontrol(inv);
  if ( v != None ) {
   v.DropFrom(location);
  }
 }
}

function ShowWeapon()
{
    Weapon = PendingWeapon;
    if(Weapon!=None)
     Weapon.BringUp();
    PendingWeapon = None;
//    Inventory.ChangedWeapon();
}

function HideWeapon()
{
    PendingWeapon = Weapon;
	if ( Weapon != None )
		Weapon.PutDown();
	Weapon = None;
}

defaultproperties
{
}
