//=============================================================================
// MaleOneDriver.
//=============================================================================
class MaleOneDriver expands MaleOne;

// Incorporate the following stuff into your player class to support drivables
/////////////////////////////////////////////////////////////////////////////////////////////////////
var bool bDriving;
var VehicleControl activecontroller;
var float BobDefault;
var float MaxStepHeightDefault;
var float altitude,latitude,longitude;
var bool previousbFire,previousbAltFire,previousbjump,previousbduck;
var bool CtlbJustFired,CtlbFire,CtlbJustAltFired,CtlbAltFire;
var float CtlaForward,CtlaTurn;
var float CtlaStrafe,CtlaUp,CtlaLookUp;
var bool CtlbDuck,CtlbJump,CtlbJustDucked,CtlbJustJumped;
var bool bPreviousDriving;

replication
{
 unreliable if(Role==ROLE_Authority)
               bDriving,activecontroller;
 unreliable if(Role==ROLE_Authority)
               DrClientLocationUpdate;
 reliable if(Role<ROLE_Authority)
               DropItem;
}

simulated function DrClientLocationUpdate()
{
 if(activecontroller.bStationaryController) {
  SetLocation(activecontroller.currentlocation);
 }
 if(!activecontroller.bPlayerCanLook) {
  SetRotation(activecontroller.currentrotation);
  if(viewtarget!=None) {
//   bBehindview=true;
   ViewRotation=viewtarget.rotation;
  }
 }
}

function PlayerTick(float DeltaTime)
{
 if(activecontroller!=None) {
  DrClientLocationUpdate();
 }
 super.PlayerTick(DeltaTime);
}

// modified playerinput must prevent player movement while driving,
// and still supply as many inputs to the vehiclecontrol as possible
event PlayerInput( float DeltaTime )
{
 local float SmoothTime, FOVScale, MouseScale, KbdScale, AbsSmooth, AbsInput;
 local Inventory inv;
 local vehiclecontrol v;

 Super.PlayerInput(DeltaTime);

 if(bDriving) { // send input to vehicle control
  Bob=0;
  CtlbJustAltFired=false; 
  CtlbJustFired=false;
  if(bFire==0) 
   CtlbFire=false;
   
  if(bAltFire==0) 
   CtlbAltFire=false;
     
  if(CtlbFire && !previousbFire)
   CtlbJustFired=true;
 
  if(CtlbAltFire && !previousbAltFire)
   CtlbJustAltFired=true;

  previousbFire=CtlbFire;
  previousbAltFire=CtlbAltFire;

  if(aUp>0)
   CtlbJump=true;
  else
   CtlbJump=false;

  if(aUp<0)
   CtlbDuck=true;
  else
   CtlbDuck=false;
   
  previousbJump=CtlbJump;
  previousbDuck=CtlbDuck;
   
  CtlaForward=aForward;
  CtlaTurn=aTurn;
  CtlaStrafe=aStrafe;
  CtlaUp=aUp;
  CtlaLookUp=aLookUp;
	 
  aBaseX=0;
  aBaseY=0;
  aBaseZ=0;
  aForward=0;
  if(activecontroller.bPlayerCrouch) {
   bDuck = 1;
   bIsCrouching=true;
  }
  else {
   bIsCrouching=false;
   bDuck=0;
  }
      
  activecontroller.ControlVehicle(CtlbFire,CtlbAltFire,
                                  CtlaForward,CtlaTurn,CtlaStrafe,CtlaUp,CtlaLookUp);
                    
  bPressedJump=false;
  bWasForward = false;
  bWasLeft = false;
  bWasRight = false;
  bWasBack = false;
     
  if(!activecontroller.bPlayerCanLook) {
   aMouseX=0;
   aMouseY=0;
   aLookup=0;
   aTurn=0;
  }
  aStrafe=0;
  aUp=0;
 }
 else {
  Bob=BobDefault;
  if(bPreviousDriving) {
   bIsCrouching=false;
   bDuck=0;
  }
 }
 bPreviousDriving=bDriving;
}

simulated function PostRender( canvas Canvas )
{
 Super.PostRender(Canvas);

 if (!bShowMenu && bDriving) { // i.e. if we're controlling a vehicle and are not in any menus
    if(activecontroller!=None) 
     activecontroller.PostRender( Canvas );
   }
}

function HideWeapon()
{
    PendingWeapon = Weapon;
	if ( Weapon != None )
		Weapon.PutDown();
	Weapon = None;
}

function ShowWeapon()
{
    Weapon = PendingWeapon;
    if(Weapon!=None)
     Weapon.BringUp();
    PendingWeapon = None;
//    Inventory.ChangedWeapon();
}

	//Player Jumped
function DoJump( optional float F )
{
 if(bDriving) {
  CtlbJump=true;
 }
 else
  super.DoJump(F);
}

function dropallvehiclecontrols()
{
 local inventory inv;
 local vehiclecontrol v;
 
 // drop all controllers
 if(activecontroller!=none)
  activecontroller.Activate(); // deactivate controller
  
 bDriving=false;
 Activecontroller=none;
 for (inv=Inventory; inv!=None; inv=inv.Inventory) {
  v = vehiclecontrol(inv);
  if ( v != None ) {
   Bob=BobDefault;
   v.DropFrom(location);
  }
 }
}

function Died(pawn instigatedBy, name damageType, vector HitLocation)
{
 dropallvehiclecontrols();
 Super.Died(instigatedBy, damageType, HitLocation);
}

event Destroyed()
{
 dropallvehiclecontrols();
 Super.Destroyed();
}

simulated function ChangedWeapon()
{
	if(bDriving) {
	 if(activecontroller!=None)
	  if(activecontroller.bPlayerHasWeapons==false) {
	   return;
	  }
	}
	super.ChangedWeapon();
}

function ServerRestartPlayer()       // implemented here because GameInfo tends to throw away the inventory
{
 super.ServerRestartPlayer();
 bDriving=false;
}
 
function SpawnLicense()
{
 local driverslicense lic;

 lic=spawn(class'DriversLicense');
 if(lic==None)
  log(tag $ "Failed to spawn Driver's License!");
 else {
  lic.bUnderstandsRemotes=true;
  AddInventory(lic);
 }
}

function OnBeginPlay()
{
 previousbFire=false;
 previousbAltFire=false;
 BobDefault=Bob;
}

exec function TX(float x)
{
 latitude = x;
 Clientmessage("Target grid location: (TX)" $ latitude $ ",(TY)" $ longitude $ " (TZ): " $ altitude);
}

exec function TY(float x)
{
 longitude = x;
 Clientmessage("Target grid location: (TX)" $ latitude $ ",(TY)" $ longitude $ " (TZ): " $ altitude);
}

exec function TZ(float x)
{
 altitude = x;
 Clientmessage("Target grid location: (TX)" $ latitude $ ",(TY)" $ longitude $ " (TZ): " $ altitude);
}

exec function Targ()
{
 Clientmessage("Target grid location: (TX)" $ latitude $ ",(TY)" $ longitude $ " (TZ): " $ altitude);
}

exec function CalcBall()
{
 local float Yaw,HighTraj,flighttime;
 
 if(bDriving) {
  if(activecontroller!=None) {
   Clientmessage("Target grid location: (TX)" $ latitude $ ",(TY)" $ longitude $ " (TZ): " $ altitude);
   activecontroller.BallisticCalculation(latitude*10000+level.location.X,longitude*10000+level.location.Y,altitude*100+level.location.Z,Yaw,hightraj,flighttime);
   ClientMessage("Bearing  : " $ Yaw);
   ClientMessage("Elevation: " $ HighTraj);
   ClientMessage("Estimated flight time: " $ flighttime);
  }
 }
 else
  Clientmessage("Use CalcBall when controlling something");
}

// The player wants to activate/deactivate selected item
simulated exec function ActivateItem()
{
	if( bShowMenu || Level.Pauser!="" )
		return;
	if (vehiclecontrol(SelectedItem)!=None) {
	 if(activecontroller!=None && activecontroller!=selecteditem) {
	  activecontroller.Activate();
	  DeactivateController();
	 }
	  
 	 SelectedItem.Activate();
 	 if(selecteditem.bActive)
  	  ActivateController(vehiclecontrol(selecteditem));
 	 else
 	  DeactivateController();
  	  
 	 return;
 	}
 	super.ActivateItem();
}

// The player wants to fire.
exec function Fire( optional float F )
{
 if(bDriving) 
  if(activecontroller!=None) 
   if(!activecontroller.bPlayerHasWeapons) {
    CtlbFire=true;
    return;
   }
   
 super.Fire(F);
}

// The player wants to alternate-fire.
exec function AltFire( optional float F )
{ 
 if(bDriving) 
  if(activecontroller!=None) 
   if(!activecontroller.bPlayerHasWeapons) {
    CtlbAltFire=true;
    return;
   }
 super.AltFire(F);
}

simulated function ActivateController(vehiclecontrol vc)
{
 if(vc.bPlayerCrouch) {
  bIsCrouching=true;
  bDuck=1;
 }
 bJustFired=false;      // to prevent the drivable from firing until the player actually fires again
 bJustAltFired=false;
 bDriving = true;
 activecontroller=vc;
  
 if(!vc.bPlayerHasWeapons)
  HideWeapon();
 
 if(vc.bStationaryController) {
//  SetCollision(false,true,true);
  SetPhysics(PHYS_None);
//  bCollideWorld=false;
//  GotoState('Driving');
 }
}

simulated function DeactivateController()
{
 local vehiclecontrol vc;
 
 vc=activecontroller;
 bDriving=false;
 bRotateToDesired = true;
 SetDefaultDisplayProperties();
 if(!activecontroller.bPlayerHasWeapons)
  ShowWeapon();
           
 if(activecontroller.bPlayerCrouch) {
  bIsCrouching=false;
  bDuck=0;
 }
 activecontroller=None;
 if(vc.bStationaryController) {
//  bCollideWorld=true;
//  SetCollision(true,true,true);
  SetPhysics(PHYS_Walking);
//  StartWalk();
 }
}

exec function DropItem()
{
 local Inventory Inv;
 
	if( Level.NetMode == NM_Client )
		return;
	if( SelectedItem==None || !SelectedItem.bDisplayableInv || !SelectedItem.bActivatable )
		return;
	Inv=selecteditem;
	if(selecteditem.bActive)
	 ActivateItem();
	 
	selecteditem.Velocity = Vector(ViewRotation) * 500 + vect(0,0,220);
	inv.DropFrom(Location);
}

function Touch(Actor Other)
{
 if(VehicleControl(Other)!=None)
  if(FindInventoryType(class'DriversLicense')==None)
   SpawnLicense();
 Super.Touch(Other);
}

state Driving // basically the same stuff as the ghost cheat
{
 ignores Bump;
 
 function TakeDamage( int Damage, Pawn instigatedBy, Vector hitlocation, 
  					Vector momentum, name damageType)
 {
  super.TakeDamage(damage,instigatedby,hitlocation,momentum,damagetype);
  SetPhysics(PHYS_None);
 }
 
 function ProcessMove(float DeltaTime, vector NewAccel, eDodgeDir DodgeMove, rotator DeltaRot)	
 {
 }

 function PlayerMove(float DeltaTime)
 {
 	local rotator newRotation;
	local vector X,Y,Z;

	Acceleration = vect(0,0,0);  

//	UpdateRotation(DeltaTime, 1);

	if ( Role < ROLE_Authority ) // then save this move and replicate it
		ReplicateMove(DeltaTime, Acceleration, DODGE_None, rot(0,0,0));
	else
		ProcessMove(DeltaTime, Acceleration, DODGE_None, rot(0,0,0));
 }

 event PlayerTick( float DeltaTime )
 {
 	if ( bUpdatePosition )
 		ClientUpdatePosition();

 	PlayerMove(DeltaTime);
 }


 
 function BeginState()
 {
	EyeHeight = BaseEyeHeight;
	SetPhysics(PHYS_None);
	log("Player entered driving state");
 }

}

/////////////////////////////////////////////////////////////////////////////////////////////////////

defaultproperties
{
     MenuName="Male 1 Driver"
     bAlwaysRelevant=True
}
