//=============================================================================
// HoverCraft.
//=============================================================================
class HoverCraft expands Drivable;

simulated function InterpretControls(bool bJustFired,bool bFire,bool bJustAltFired,bool bAltFire,
                           float aVehicleSpeedControl,float aTurretTurn,float aVehicleTurn,
                           float aVehicleUp,float aTurretUp,bool bJustJumped,bool bJustDucked)
{
 local float NewDesiredSpeed;

 if(aVehicleTurn<0)
  controlinputYaw = (aVehicleTurn/16384.0)*YawLeftRate;
 else
  controlinputYaw = (aVehicleTurn/16384.0)*YawRightRate;
  
 NewDesiredSpeed = 0;
 
 if(aVehicleSpeedControl<0)
  NewDesiredSpeed = MinSpeed/16384.0*abs(aVehicleSpeedControl);
 
 if(aVehicleSpeedControl>0)
  NewDesiredSpeed = MaxSpeed/16384.0*abs(aVehicleSpeedControl);

 DesiredSpeed = NewDesiredSpeed;
}

// UpdateSpeed overridden because hovercraft can slide
simulated function UpdateSpeed(float DeltaTime,float traction)
{
 local float accel;

  
 accel=0.0;
 if(MaxSpeed>0) {
  if(DesiredSpeed<CurrentSpeed) {
   if(CurrentSpeed>0.0 && MaxDeceleration>MaxReverseAcceleration)
    accel=MAX(DesiredSpeed-CurrentSpeed,-MaxDeceleration*deltatime*traction); // note: desiredspeed-currentspeed is negative, so accel is negative
   else
    accel=MAX(DesiredSpeed-CurrentSpeed,-MaxReverseAcceleration*deltatime*traction); // note: desiredspeed-currentspeed is negative, so accel is negative
  }
  if(DesiredSpeed>CurrentSpeed) {
   if(CurrentSpeed<0.0 && MaxDeceleration>MaxAcceleration)
    accel=MIN(DesiredSpeed-CurrentSpeed,MaxDeceleration*deltatime*traction); 
   else
    accel=MIN(DesiredSpeed-CurrentSpeed,MaxAcceleration*deltatime*traction); 
  }
 }
 CurrentSpeed+=accel;
 if(CurrentSpeed>MaxSpeed*traction)
  CurrentSpeed=MaxSpeed*traction;
 else
 if(CurrentSpeed<MinSpeed*traction)
  CurrentSpeed=MinSpeed*traction;
  
 linearvelocity = CurrentSpeed*vector(CurrentRotation);
}

defaultproperties
{
     bBot_ShowVehicleLocation=True
     DestructionEffect=None
     PhysicsType=TerrainFollowing
     PhysicsFlatBottom=True
     PhysicsHover=True
     PhysicalRotationRate=(Pitch=0,Yaw=0,Roll=0)
     CrashingSound=None
     DestroyedSound=None
     Elasticity=0.000000
     bRepairable=False
     RepairTime=0.000000
     MoverGlideType=MV_GlideByTime
     bDamageTriggered=True
     Buoyancy=100.000000
}
