//=============================================================================
// GunBarrel.
//=============================================================================
class GunBarrel expands Drivable;

var() int ProjectileFireCycle;
var() int ProjectileFirePhase;
var() int AltProjectileFireCycle;
var() int AltProjectileFirePhase;
var()   class<projectile> ProjectileClass;
var()   class<projectile> AltProjectileClass;
var() float ProjectileReloadTime;
var() float AltProjectileSpeed;
var() float AltProjectileReloadTime;
var() vector FireOffset;
var() int ProjectileAmmo; 
var() class<ammo> ProjectileAmmoName;
var() int ProjectileGetCount;
var() float ProjectileGetDelay;
var() int AltProjectileAmmo; 
var() class<ammo> AltProjectileAmmoName;
var() int AltProjectileGetCount;
var() float AltProjectileGetDelay;
var() sound ProjectileSound;
var() sound AltProjectileSound;
var() int Recoil;
var() bool ProjectileContinuousFire;
var() bool AltProjectileContinuousFire;
var() float Inaccuracy;

// This stuff copied from class weapon - for instant hit stuff
var() bool	  bInstantHit;		 // If true, instant hit rather than projectile firing weapon
var() bool	  bAltInstantHit;	 // If true, instant hit rather than projectile firing weapon for AltFire
var(WeaponAI) bool	  bWarnTarget;		 // When firing projectile, warn the target
var(WeaponAI) bool	  bAltWarnTarget;	 // When firing alternate projectile, warn the target
var()	name DamageType;
var()	name AltDamageType;
var() float ProjectileRange;
var() float AltProjectileRange;
var(WeaponAI)	float	AIRating;
var(WeaponAI)	float	RefireRate;
var(WeaponAI)	float	AltRefireRate;
var() float ProjectileDamage;
var() float AltProjectileDamage;


var int CurrentProjectileAmmo;
var int CurrentAltProjectileAmmo;
var bool bProjectileLoaded;
var bool bAltProjectileLoaded;
var int currentprojectilephase;
var int currentaltprojectilephase;
var int currentrecoilpos;    

replication
{
 unreliable if(Role==ROLE_Authority)
          currentrecoilpos;
}

function Fire( float Value )
{
 if(ProjectileFireCycle>0) {
  if(currentprojectilephase != projectilefirephase) {
   if(bProjectileLoaded) {
    CurrentProjectileAmmo++;
    bProjectileLoaded=false;
   }
  }
  currentprojectilephase = (currentprojectilephase+1)%projectilefirecycle;
  SetTimer(ProjectileReloadTime,false);		
 }
 if (bProjectileLoaded)
 {
  if(bInstantHit)
   TraceFire();
  else 
   ProjectileFire(ProjectileClass, ProjectileSpeed, false);
   
  PlaySound(ProjectileSound);
  bProjectileLoaded=false;
  CurrentRecoilPos=Recoil;
  if(CurrentProjectileAmmo>0)  // still something to load
   SetTimer(ProjectileReloadTime,false);		
  else                          // otherwise, try to get ammo from player
   SetTimer(ProjectileGetDelay,false);		
 }
}


function AltFire( float Value )
{
 if(AltProjectileFireCycle>0) {
  if(currentAltprojectilephase != Altprojectilefirephase) {
   if(bAltProjectileLoaded) {
    CurrentAltProjectileAmmo++;
    bAltProjectileLoaded=false;
   }   
  }
  currentAltprojectilephase = (currentAltprojectilephase+1)%Altprojectilefirecycle;
  SetTimer(AltProjectileReloadTime,false);		
 }
 if (bAltProjectileLoaded)
 {
  if(bAltInstantHit)
   TraceAltFire();
  else
   ProjectileFire(AltProjectileClass, AltProjectileSpeed, false);
   
  PlaySound(AltProjectileSound);
  bAltProjectileLoaded=false;
  CurrentRecoilPos=Recoil;
  if(CurrentAltProjectileAmmo>0)  // still something to load
   SetTimer(AltProjectileReloadTime,false);		
  else                          // otherwise, try to get ammo from player
   SetTimer(AltProjectileGetDelay,false);		
 }
}

function TraceFire()
{
	local vector HitLocation, HitNormal, StartTrace, EndTrace, X,Y,Z;
	local actor Other;
	local Pawn PawnOwner;
    local rotator randrot;
 
    randrot.Yaw = Frand()*2*Inaccuracy-Inaccuracy;
    randrot.Pitch = Frand()*2*Inaccuracy-Inaccuracy;
    randrot.Roll = Frand()*2*Inaccuracy-Inaccuracy;

	PawnOwner = Pawn(Owner);

	GetAxes(Rotation,X,Y,Z);
	StartTrace = Location + FireOffset.X * X + FireOffset.Y * Y + FireOffset.Z * Z; 
	EndTrace = StartTrace + vector(rotation+randrot)*altprojectilerange;
	Other = Trace(HitLocation,HitNormal,EndTrace,StartTrace,true);
	if(Other!=None)
 	 ProcessTraceHit(Other, HitLocation, HitNormal, X,Y,Z);
}

function TraceAltFire()
{
	local vector HitLocation, HitNormal, StartTrace, EndTrace, X,Y,Z;
	local actor Other;
	local Pawn PawnOwner;
    local rotator randrot;
 
    randrot.Yaw = Frand()*2*Inaccuracy-Inaccuracy;
    randrot.Pitch = Frand()*2*Inaccuracy-Inaccuracy;
    randrot.Roll = Frand()*2*Inaccuracy-Inaccuracy;

	PawnOwner = Pawn(Owner);

	GetAxes(Rotation,X,Y,Z);
	StartTrace = Location + FireOffset.X * X + FireOffset.Y * Y + FireOffset.Z * Z; 
	EndTrace = StartTrace + vector(rotation+randrot)*altprojectilerange;
	Other = Trace(HitLocation,HitNormal,EndTrace,StartTrace,true);
	if(Other!=None)
 	 ProcessAltTraceHit(Other, HitLocation, HitNormal, X,Y,Z);
}

function ProcessTraceHit(Actor Other, Vector HitLocation, Vector HitNormal, Vector X, Vector Y, Vector Z)
{
	if (Other == Level) 
		Spawn(class'LightWallHitEffect',,, HitLocation+HitNormal*9, Rotator(HitNormal));
	else if ( (Other!=self) && (Other != None) ) 
	{
		if ( !Other.IsA('Pawn') && !Other.IsA('Carcass') )
			spawn(class'SpriteSmokePuff',,,HitLocation+HitNormal*9);
		if ( Other.IsA('ScriptedPawn') && (FRand() < 0.2) )
			Pawn(Other).WarnTarget(Pawn(Owner), 500, X);
		Other.TakeDamage(ProjectileDamage, Instigator, HitLocation, ProjectileDamage*500.0*X, DamageType);
	}
}

function ProcessAltTraceHit(Actor Other, Vector HitLocation, Vector HitNormal, Vector X, Vector Y, Vector Z)
{
	if (Other == Level) 
		Spawn(class'LightWallHitEffect',,, HitLocation+HitNormal*9, Rotator(HitNormal));
	else if ( (Other!=self) && (Other != None) ) 
	{
		if ( !Other.IsA('Pawn') && !Other.IsA('Carcass') )
			spawn(class'SpriteSmokePuff',,,HitLocation+HitNormal*9);
		if ( Other.IsA('ScriptedPawn') && (FRand() < 0.2) )
			Pawn(Other).WarnTarget(Pawn(Owner), 500, X);
		Other.TakeDamage(AltProjectileDamage, Instigator, HitLocation, AltProjectileDamage*500.0*X, AltDamageType);
	}
}


// (basically cut and pasted from Weapon class)
function Projectile ProjectileFire(class<projectile> ProjClass, float ProjSpeed, bool bWarn)
{
	local Vector Start, X,Y,Z;
    local Projectile project;
    local rotator randrot;
 
    randrot.Yaw = Frand()*2*Inaccuracy-Inaccuracy;
    randrot.Pitch = Frand()*2*Inaccuracy-Inaccuracy;
    randrot.Roll = Frand()*2*Inaccuracy-Inaccuracy;

	
	GetAxes(Rotation,X,Y,Z);
	Start = Location + FireOffset.X * X + FireOffset.Y * Y + FireOffset.Z * Z; 
	project = Spawn(ProjClass,,, Start,rotation+randrot);	
	project.velocity=ProjSpeed*vector(rotation+randrot);
	project.Instigator = controllingplayer;
	return project;
}

simulated function vector CalculateOwnLocation()
{
 local vector recoilvect;
 
 recoilvect=currentrecoilpos*vector(RealWorldRotation(CurrentRotation,planeangles));
 return qtz(RealWorldLocation(CurrentLocation,planeangles)+qtz(Origin)-qtz(recoilvect));
}

simulated function DoPhysics(float DeltaTime)
{
  if(CurrentRecoilPos!=0)
   CurrentRecoilPos-=Recoil/10.0;
}

simulated function InterpretControls(bool bJustFired,bool bFire,bool bJustAltFired,bool bAltFire,
                           float aVehicleSpeedControl,float aTurretTurn,float aVehicleTurn,
                           float aVehicleUp,float aTurretUp,bool bJustJumped,bool bJustDucked)
{
 local float NewDesiredSpeed;

 if(bJustFired || (bFire && ProjectileContinuousFire)) {
  Fire(0);
  CurrentController.ReportedProjectileLoaded=false;    // status may be incorrect till the next Tick()
 }
 if(bJustAltFired || (bAltFire && AltProjectileContinuousFire)) {
  AltFire(0);
  CurrentController.ReportedAltProjectileLoaded=false; // status may be incorrect till the next Tick()
 }

// this stuff is there just in case anybody wants a simple gun on wheels or something like that
 super.InterpretControls(bJustFired, bFire, bJustAltFired, bAltFire, aVehicleSpeedControl,
                         aTurretTurn, aVehicleTurn, aVehicleUp, aTurretUp, bJustJumped, bJustDucked);
}

// Initialization
function BeginPlay()
{
 local int i;

 CurrentRecoilPos = 0;
 CurrentProjectileAmmo=ProjectileAmmo;
 CurrentAltProjectileAmmo=AltProjectileAmmo;
 bProjectileLoaded=false;
 bAltProjectileLoaded=false;
 currentprojectilephase=0;
 currentaltprojectilephase=0;
 super.beginplay();
}

function PostBeginPlay()
{
 super.postbeginplay();
 Timer();
}

function Timer()
{
 ReloadWeapons();
 ReloadWeaponsFromInventory();
}

function Activation()
{
 currentprojectilephase=0;
 currentaltprojectilephase=0;
 super.Activation();
 Timer();
}

function ReloadWeapons()
{
 if(!bProjectileLoaded && ProjectileReloadTime>0) {
  if(CurrentProjectileAmmo>0) {
   bProjectileLoaded=true;
   CurrentProjectileAmmo--;
   CurrentRecoilPos = 0;
  }
 }
 if(!bAltProjectileLoaded && (AltProjectileClass!=None)) {
  if(CurrentAltProjectileAmmo>0) {
   bAltProjectileLoaded=true;
   CurrentAltProjectileAmmo--;
   CurrentRecoilPos = 0;
  }
 }
}

function ReloadWeaponsFromInventory()
{
 if(!bProjectileLoaded && ProjectileReloadTime>0 && currentcontroller!=None) {
  if(CurrentProjectileAmmo>0) {
   bProjectileLoaded=true;
   CurrentProjectileAmmo--;
   CurrentRecoilPos = 0;
  }
  else {
   if(CurrentController.FindAmmo(ProjectileAmmoName,ProjectileGetCount)) {
    CurrentProjectileAmmo+=ProjectileGetCount;
    SetTimer(ProjectileReloadTime,false);		
    currentprojectilephase=0;    
   }
  }
 }
 if(!bAltProjectileLoaded && (AltProjectileClass!=None) && (currentcontroller!=None)) {
  if(CurrentAltProjectileAmmo<=0) {
   if(CurrentController.FindAmmo(AltProjectileAmmoName,AltProjectileGetCount)) {
    CurrentAltProjectileAmmo+=AltProjectileGetCount;
   
    SetTimer(AltProjectileReloadTime,false);		
    currentaltprojectilephase=0;    
   }
  }
  else { 
   bAltProjectileLoaded=true;
   CurrentAltProjectileAmmo--;
   CurrentRecoilPos = 0;
  }
 }
}

simulated function Tick(float DeltaTime)
{
 if(bProjectileLoaded && CurrentController!=None)
  CurrentController.ReportedProjectileLoaded=true;
 if(bAltProjectileLoaded && CurrentController!=None)
  CurrentController.ReportedAltProjectileLoaded=true;
 super.Tick(DeltaTime);
}

defaultproperties
{
     ProjectileReloadTime=1.000000
     Recoil=10
     Inaccuracy=20.000000
     DamageType=shot
     AltDamageType=shot
     ProjectileRange=20000.000000
     AltProjectileRange=20000.000000
     ProjectileDamage=50.000000
     AltProjectileDamage=50.000000
     bBot_ShowTurretLocation=True
     Armor=80
     InitialHitPoints=10
     FullHitPoints=10
     DestructionEffect=None
     PhysicsType=StaticMover
     PhysicalRotationRate=(Pitch=0,Yaw=0,Roll=0)
     CrashingSound=None
     DestroyedSound=None
     Elasticity=0.000000
     bPhysics=False
     bRepairable=False
     RepairTime=0.000000
     MoverGlideType=MV_GlideByTime
     bDamageTriggered=True
}
