//=============================================================================
// DrivableMountPoint.
//=============================================================================
class DrivableMountPoint expands drivable;

// These two functions allow attaching and detaching of a child component during play.
// A DrivableMountPoint should have NO childtags, since these functions modify that array.
// A vehiclecontrol that can optionally used with this mountpoint, should have the tag of the mountpoint
// as its controlledtag.
simulated function bool AttachChild(Actor newchild)
{
 if(drivablechildcount>0)
  return false;
 if(drivable(newchild)!=None) {
  if(drivable(newchild).parentDrv==None)
   drivable(newchild).parentDrv=self;
  else
   return false;
 }

 StoreDrivableChildInfo(DrivableChild[0],newchild);

 drivablechildcount=1;

}

simulated function bool DetachChild()
{
 if(drivablechildcount<=0)
  return false;
 
 if(drivable(drivablechild[0].act)!=None) 
  drivable(drivablechild[0].act).ParentDrv=None;
 
 drivablechild[0].act.instigator=None;
  
 drivablechildcount=0;
}

defaultproperties
{
     PhysicalRotationRate=(Pitch=16384,Yaw=16384,Roll=16384)
     bHidden=True
     DrawType=DT_Sprite
}
