//=============================================================================
// DrivableFeedback.
//=============================================================================
class DrivableFeedback expands Actor;

var (Collision) float BouncePercentage;
var (Collision) float DamagePercentage;
var (Collision) name  ZoneTag;
var (Collision) bool  bRestrictToZoneTag;  
var () vector WaterLift;
var () vector AirLift;
var () bool bIsGroundFeedback; // set this flag for only one of all the feedbacks for any one drivable
var () bool bIsAuxiliaryFeedback; // used by TerrainFollowing physics to handle rising over obstacles.
var bool CurrentlyOnGround; // set by drivable, read by drivable
var float distancetocenter;
var rotator angletocenter;
var actor alreadycollideswith;
var int alreadycollidescount;
var actor collideswith;
var int collidescount;
var vector PreviousLocation;

var float hittime;
var actor hitactor;
var vector hitlocation;
var vector hitnormal;
var rotator CurrentRotation;

replication
{
 unreliable if(Role==ROLE_Authority)
              CurrentRotation;
 unreliable if(Role==ROLE_Authority)
              ClientSetLocation;
}

function Tick(float DeltaTime)
{
 if(Role==ROLE_Authority) {
  CurrentRotation=rotation;
  ClientSetLocation();
 }
}

simulated function ClientSetLocation()
{
 setrotation(CurrentRotation);
}

function vector Lift()
{
	 if(region.Zone.bWaterZone)
	  return WaterLift;
	 else
	  return AirLift;
}

defaultproperties
{
     bHidden=True
     bAlwaysRelevant=True
     bDirectional=True
     Texture=Texture'UnrealShare.Icons.Crosshair6'
     CollisionRadius=0.000000
     CollisionHeight=0.000000
}
