//=============================================================================
// DrivableDecoration.
// Use as lightweight decoration
//=============================================================================
class DrivableDecoration expands Actor;

var float TempRotYaw,TempRotPitch,TempRotRoll;
var float TempLocX,TempLocY,TempLocZ;

replication
{
 reliable if(Role==ROLE_Authority)
              TempRotYaw,TempRotPitch,TempRotRoll,TempLocX,TempLocY,TempLocZ;
}

simulated function ClientUpdateLocation()
{
 local vector loc;
 local rotator rot;
 
 loc.X=TempLocX;
 loc.Y=TempLocY;
 loc.Z=TempLocZ;
 rot.Yaw=TempRotYaw;
 rot.Pitch=TempRotPitch;
 rot.Roll=TempRotRoll;
 SetLocation(loc);
 SetRotation(rot);
}

simulated function ReplicateLocation(vector Location,rotator Rotation)
{
 TempLocX=Location.X;
 TempLocY=Location.Y;
 TempLocZ=Location.Z;
 TempRotYaw=rotation.yaw;
 TempRotPitch=rotation.pitch;
 TempRotRoll=rotation.Roll;
}

simulated function Tick(float DeltaTime)
{
 ClientUpdateLocation();
}

defaultproperties
{
     RemoteRole=ROLE_SimulatedProxy
     bDirectional=True
     DrawType=DT_Mesh
     Mesh=LodMesh'UnrealShare.AmplifierM'
}
