//=============================================================================
// DrivableClamp.
//=============================================================================
// Allows attaching of drivables to other drivables.
// Unlike the passenger code, clamping prevents control of the attached drivable.
// You can make a DrivableClamp a child of a DrivableCable, and the DrivableCable
// child of another drivable. This way, you can create a crane.
// Note that you cannot clamp more than one drivable at a time.
class DrivableClamp expands drivable;

enum ClampControlMethod {
 JumpDuck,
 FireAltFire
};

var () name InitiallyClampedTag;
var () ClampControlMethod ControlMethod;
var actor clampedactor;
var bool firstmove;
var vector clampoffset;

simulated function InterpretControls(bool bJustFired,bool bFire,bool bJustAltFired,bool bAltFire,
                           float aVehicleSpeedControl,float aTurretTurn,float aVehicleTurn,
                           float aVehicleUp,float aTurretUp,bool bJustJumped,bool bJustDucked)
{
 local float newspeed;
 newspeed=0;
 
 switch(ControlMethod) {
  case JumpDuck:
  if(aVehicleUp>0) log("Jump");
  if(aVehicleUp<0) log("Duck");
       if(bJustJumped && clampedactor==None) 
        GrabActor();
       else
       if(bJustDucked && clampedactor!=None)
        ReleaseActor();
       break;
  case FireAltFire:
       if(bFire && clampedactor==None)
        GrabActor();
       else
       if(bAltFire && clampedactor!=None)
        ReleaseActor();
       break;
 }
 desiredspeed=newspeed;
}

function GrabActor()
{
 local DrivableFeedback fb;
 local actor act;
 
 fb=DrivableFeedback(feedback[groundfeedbackindex].act);
 if(fb!=None) {
  if(fb.bIsGroundFeedback) {
   foreach fb.touchingactors(class'Actor',act) {
    if(Drivable(act)!=None) {
     if(!Drivable(act).bClamped) {
      clampoffset=act.location-fb.location;
      Drivable(act).bClamped=true;
      clampedactor=act;
      return;
     }
    }
    else {
     clampoffset=act.location-fb.location;
     clampedactor=act;
     act.SetPhysics(PHYS_None);
     return;
    }
   }
  }
 }
}

function ReleaseActor()
{
log("release");
 if(Drivable(clampedactor)!=None) 
  drivable(clampedactor).bClamped=false;
 else
  clampedactor.SetPhysics(PHYS_Falling);
  
 clampedactor=None;
}

simulated function PostBeginPlay()
{
 local actor act;
 local drivablefeedback fb;
 
 super.postbeginplay();
 fb=DrivableFeedback(feedback[groundfeedbackindex].act);
 if(InitiallyClampedTag!='' && fb!=None && fb.bIsGroundfeedback) {
  foreach allactors(class'actor',act,InitiallyClampedTag) {
   if(Drivable(act)!=None) {
    if(!Drivable(act).bClamped) {
     Drivable(act).bClamped=true;
     clampoffset=act.location-fb.location;
     clampedactor=act;
    }
   }
   else {
    clampedactor=act;
    clampoffset=act.location-fb.location;
    act.SetPhysics(PHYS_None);
   }
  }
 }   
 if(clampedactor!=None) {
  firstmove=true;
 }
}

simulated function UpdateOwnLocation()
{
 local DrivableFeedback fb;
 
 SetRotation(RealWorldRotation(CurrentRotation,planeangles));
 MoveSmooth(RealWorldLocation(CurrentLocation,planeangles)+Origin-Location);
 
 fb=DrivableFeedback(Feedback[GroundFeedbackIndex].act);
 if(fb!=None && fb.bIsGroundFeedback) {
  if(clampedactor!=None) {
   if(firstmove)
    clampedactor.setlocation(CalculateChildLocation(Feedback[GroundFeedbackIndex],qtz(RealWorldLocation(CurrentLocation,planeangles)+Origin),RealWorldRotation(CurrentRotation,planeangles)));
   else
    clampedactor.movesmooth(RealWorldLocation(RealWorldLocation(Feedback[GroundFeedbackIndex].originoffset+clampoffset,CurrentRotation)+CurrentLocation,planeangles)+Origin-clampedactor.location);
  }
  firstmove=false;
 }
}

defaultproperties
{
     PhysicalRotationRate=(Pitch=16384,Yaw=16384,Roll=16384)
     CrashingSound=None
     DestroyedSound=None
     bRepairable=False
     RepairTime=0.000000
     MoverGlideType=MV_GlideByTime
}
