//=============================================================================
// DrivableCable.
//=============================================================================
class DrivableCable expands drivable;

enum CableControlMethod {
 VehicleSpeed,
 VehicleTurn,
 TurretUp,
 TurretTurn,
 JumpDuck,
 FireAltFire
};

var () CableControlMethod ControlMethod;
var () float MaxLength;
var () float InitialLength;
var float currentlength;

replication
{
 reliable if(Role==ROLE_Authority)
  currentlength;
}

simulated function PostBeginPlay()
{
 local DrivablePathNode prevnode,firstnode,pn;
 local int i;
 
 super.PostBeginPlay();
 
 currentlength=InitialLength;
 currentspeed=0;
}

simulated function Tick(float DeltaTime) // overridden because not many functions get called on the client
{
 Super.Tick(DeltaTime);
 MainScale.scale.X=CurrentLength;
}

simulated function InterpretControls(bool bJustFired,bool bFire,bool bJustAltFired,bool bAltFire,
                           float aVehicleSpeedControl,float aTurretTurn,float aVehicleTurn,
                           float aVehicleUp,float aTurretUp,bool bJustJumped,bool bJustDucked)
{
 local float newspeed;
 newspeed=0;
 
 switch(ControlMethod) {
  case VehicleSpeed:
       if(aVehicleSpeedControl>0)
        newspeed= (aVehicleSpeedControl/16384.0)*MaxSpeed;
       else 
        newspeed= abs(aVehicleSpeedControl/16384.0)*MinSpeed;
       break;
  case VehicleTurn:
       if(aVehicleTurn>0)
        newspeed= (aVehicleTurn/16384.0)*MaxSpeed;
       else 
        newspeed= abs(aVehicleTurn/16384.0)*MinSpeed;
       break;
  case TurretUp:
       if(aTurretUp>0)
        newspeed= (aTurretUp/16384.0)*MaxSpeed;
       else 
        newspeed= abs(aTurretUp/16384.0)*MinSpeed;
       break;
  case TurretTurn:
       if(aTurretTurn>0)
        newspeed= (aTurretTurn/16384.0)*MaxSpeed;
       else 
        newspeed= abs(aTurretTurn/16384.0)*MinSpeed;
       break;
  case JumpDuck:
       if(aVehicleUp>0)
        newspeed=MaxSpeed;
       else
       if(aVehicleUp<0)
        newspeed=MinSpeed;
       break;
  case FireAltFire:
       if(bFire)
        newspeed=MaxSpeed;
       else
       if(bAltFire)
        newspeed=MinSpeed;
       break;
 }
 desiredspeed=newspeed;
}

simulated function DoPhysics(float DeltaTime)
{
 local float accel;
 local float PreviousPosition;
 
 currentlength+=currentspeed*deltatime;
 if(currentlength>maxlength)
  currentlength=maxlength;
 else
 if(currentlength<0)
  currentlength=0;
 
 accel=0.0;
 if(MaxSpeed>0) {
  if(DesiredSpeed<CurrentSpeed)
   accel=MAX(DesiredSpeed-CurrentSpeed,-MaxDeceleration*deltatime); // note: desiredspeed-currentspeed is negative, so accel is negative 

  if(DesiredSpeed>CurrentSpeed)
   accel=MIN(DesiredSpeed-CurrentSpeed,MaxAcceleration*deltatime); 
 }
 CurrentSpeed+=accel;
 if(CurrentSpeed>MaxSpeed)
  CurrentSpeed=MaxSpeed;
 else
 if(CurrentSpeed<MinSpeed)
  CurrentSpeed=MinSpeed;

 CurrentLocation.Z=-CurrentLength;
}

simulated function RotationPhysics(float DeltaTime)
{
 planeangles=rot(0,0,0);
 currentrotation=rotator(vect(0,0,0)-region.zone.zonegravity);
}

defaultproperties
{
     ControlMethod=FireAltFire
     MaxLength=1.000000
     InitialLength=1.000000
     PhysicalRotationRate=(Pitch=16384,Yaw=16384,Roll=16384)
     CrashingSound=None
     DestroyedSound=None
     bRepairable=False
     RepairTime=0.000000
     MoverGlideType=MV_GlideByTime
     Sprite=Texture'UnrealShare.Icons.Crosshair5'
}
