//=============================================================================
// Car.
//=============================================================================
class Car expands Drivable;

simulated function InterpretControls(bool bJustFired,bool bFire,bool bJustAltFired,bool bAltFire,
                           float aVehicleSpeedControl,float aTurretTurn,float aVehicleTurn,
                           float aVehicleUp,float aTurretUp,bool bJustJumped,bool bJustDucked)
{
 local float NewDesiredSpeed;

 if(aVehicleTurn<0)
  controlinputYaw = (aVehicleTurn/16384.0)*YawLeftRate;
 else
  controlinputYaw = (aVehicleTurn/16384.0)*YawRightRate;
  
 NewDesiredSpeed = 0;
 
 if(aVehicleSpeedControl<0)
  NewDesiredSpeed = MinSpeed/16384.0*abs(aVehicleSpeedControl);
 
 if(aVehicleSpeedControl>0)
  NewDesiredSpeed = MaxSpeed/16384.0*abs(aVehicleSpeedControl);

 DesiredSpeed = NewDesiredSpeed;
}

// Basically the same code as the boat: a car cannot turn in-place either
simulated function RotationPhysics(float DeltaTime)
{
 local rotator NewRotation;
 local rotator NewDesiredRotation;
 local float compensationYaw,compensationPitch,compensationRoll; // not using rotator because these values are generally<1
 local float steeringfactor;
 
 if(DeltaTime<=0)
  return;
  
 if(!bPhysics)
  return;
   
 steeringfactor = deltatime*CurrentSpeed/MaxSpeed;
  
 PreviousRotation = CurrentRotation;
 CurrentRotation.Roll=normalizeangle(CurrentRotation.Roll);
 CurrentRotation.Pitch=normalizeangle(CurrentRotation.Pitch);
 CurrentRotation.Yaw=normalizeangle(CurrentRotation.Yaw);
 
 StabilizedRotation = CurrentRotation;
  
 if(currentcontroller != None) {  
  compensationYaw=ControlInputYaw;
  compensationPitch=ControlInputPitch;
  compensationRoll=ControlInputRoll; 

  StabilizedRotation.Roll += compensationRoll*steeringfactor;
  StabilizedRotation.Pitch += compensationPitch*steeringfactor;
  StabilizedRotation.Yaw += compensationYaw*steeringfactor;

  StabilizedRotation.Roll = normalizeangle(StabilizedRotation.Roll);  
  StabilizedRotation.Pitch = normalizeangle(StabilizedRotation.Pitch);  
  StabilizedRotation.Yaw = normalizeangle(StabilizedRotation.Yaw);  
 } 

 NewRotation=StabilizedRotation;
 
 // if CurrentRotation will change, play rotatingsound

 CurrentRotation = NewRotation; 
}

defaultproperties
{
     bBot_ShowVehicleLocation=True
     Armor=40
     InitialHitPoints=60
     FullHitPoints=60
     PhysicsType=TerrainFollowing
     PhysicalRotationRate=(Pitch=16384,Yaw=16384,Roll=16384)
     OperatingSound=Sound'AmbModern.Looping.fan4'
     CrashingSound=None
     DestroyedSound=None
     Elasticity=0.000000
     MoverGlideType=MV_GlideByTime
     bDamageTriggered=True
}
