//=============================================================================
// Boat.
//=============================================================================
class Boat expands Drivable;
var () bool bProportionalRudder;

simulated function InterpretControls(bool bJustFired,bool bFire,bool bJustAltFired,bool bAltFire,
                           float aVehicleSpeedControl,float aTurretTurn,float aVehicleTurn,
                           float aVehicleUp,float aTurretUp,bool bJustJumped,bool bJustDucked)
{
 local float NewDesiredSpeed;

 if(aVehicleTurn<0)
  controlinputYaw = (aVehicleTurn/16384.0)*YawLeftRate;
 else
  controlinputYaw = (aVehicleTurn/16384.0)*YawRightRate;
  
 NewDesiredSpeed = 0;
 
 if(aVehicleSpeedControl<0)
  NewDesiredSpeed = MinSpeed/16384.0*abs(aVehicleSpeedControl);
 
 if(aVehicleSpeedControl>0)
  NewDesiredSpeed = MaxSpeed/16384.0*abs(aVehicleSpeedControl);

 DesiredSpeed = NewDesiredSpeed;
}

// A boat is not stabilized, nor will it point itself at a distant target.
// However, reason for overriding the RotationPhysics is that a ship doesn't have steering without speed
simulated function RotationPhysics(float DeltaTime)
{
 local rotator NewRotation;
 local rotator NewDesiredRotation;
 local float compensationYaw,compensationPitch,compensationRoll; // not using rotator because these values are generally<1
 local float steeringfactor;
 
 if(DeltaTime<=0)
  return;
  
 if(!bPhysics)
  return;
   
 if(bProportionalRudder)
  steeringfactor = deltatime*CurrentSpeed/MaxSpeed;
 else
  steeringfactor = deltatime;
  
 PreviousRotation = CurrentRotation;
 CurrentRotation.Roll=normalizeangle(CurrentRotation.Roll);
 CurrentRotation.Pitch=normalizeangle(CurrentRotation.Pitch);
 CurrentRotation.Yaw=normalizeangle(CurrentRotation.Yaw);
 
 StabilizedRotation = CurrentRotation;
  
 if(currentcontroller != None) {  
  compensationYaw=ControlInputYaw;
  compensationPitch=ControlInputPitch;
  compensationRoll=ControlInputRoll; 

  StabilizedRotation.Roll += compensationRoll*steeringfactor;
  StabilizedRotation.Pitch += compensationPitch*steeringfactor;
  StabilizedRotation.Yaw += compensationYaw*steeringfactor;

  StabilizedRotation.Roll = normalizeangle(StabilizedRotation.Roll);  
  StabilizedRotation.Pitch = normalizeangle(StabilizedRotation.Pitch);  
  StabilizedRotation.Yaw = normalizeangle(StabilizedRotation.Yaw);  
 } 

 NewRotation=StabilizedRotation;
 
 // if CurrentRotation will change, play rotatingsound

 CurrentRotation = NewRotation; 
}

defaultproperties
{
     bProportionalRudder=True
     bBot_ShowVehicleLocation=True
     Armor=50
     InitialHitPoints=400
     FullHitPoints=400
     PhysicalRotationRate=(Pitch=0,Yaw=0,Roll=0)
     CrashingSound=None
     DestroyedSound=None
     Elasticity=0.000000
     MoverGlideType=MV_GlideByTime
     EncroachDamage=25
     bDamageTriggered=True
     Buoyancy=100.000000
}
